<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('de', array (
  'validators' => 
  array (
    'This value should be false.' => 'Dieser Wert sollte false sein.',
    'This value should be true.' => 'Dieser Wert sollte true sein.',
    'This value should be of type {{ type }}.' => 'Dieser Wert sollte vom Typ {{ type }} sein.',
    'This value should be blank.' => 'Dieser Wert sollte leer sein.',
    'The value you selected is not a valid choice.' => 'Sie haben einen ungültigen Wert ausgewählt.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'Sie müssen mindestens {{ limit }} Möglichkeit wählen.|Sie müssen mindestens {{ limit }} Möglichkeiten wählen.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'Sie dürfen höchstens {{ limit }} Möglichkeit wählen.|Sie dürfen höchstens {{ limit }} Möglichkeiten wählen.',
    'One or more of the given values is invalid.' => 'Einer oder mehrere der angegebenen Werte sind ungültig.',
    'This field was not expected.' => 'Dieses Feld wurde nicht erwartet.',
    'This field is missing.' => 'Dieses Feld fehlt.',
    'This value is not a valid date.' => 'Dieser Wert entspricht keiner gültigen Datumsangabe.',
    'This value is not a valid datetime.' => 'Dieser Wert entspricht keiner gültigen Datums- und Zeitangabe.',
    'This value is not a valid email address.' => 'Dieser Wert ist keine gültige E-Mail-Adresse.',
    'The file could not be found.' => 'Die Datei wurde nicht gefunden.',
    'The file is not readable.' => 'Die Datei ist nicht lesbar.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Die Datei ist zu groß ({{ size }} {{ suffix }}). Die maximal zulässige Größe beträgt {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'Der Dateityp ist ungültig ({{ type }}). Erlaubte Dateitypen sind {{ types }}.',
    'This value should be {{ limit }} or less.' => 'Dieser Wert sollte kleiner oder gleich {{ limit }} sein.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'Diese Zeichenkette ist zu lang. Sie sollte höchstens {{ limit }} Zeichen haben.|Diese Zeichenkette ist zu lang. Sie sollte höchstens {{ limit }} Zeichen haben.',
    'This value should be {{ limit }} or more.' => 'Dieser Wert sollte größer oder gleich {{ limit }} sein.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'Diese Zeichenkette ist zu kurz. Sie sollte mindestens {{ limit }} Zeichen haben.|Diese Zeichenkette ist zu kurz. Sie sollte mindestens {{ limit }} Zeichen haben.',
    'This value should not be blank.' => 'Dieser Wert sollte nicht leer sein.',
    'This value should not be null.' => 'Dieser Wert sollte nicht null sein.',
    'This value should be null.' => 'Dieser Wert sollte null sein.',
    'This value is not valid.' => 'Dieser Wert ist nicht gültig.',
    'This value is not a valid time.' => 'Dieser Wert entspricht keiner gültigen Zeitangabe.',
    'This value is not a valid URL.' => 'Dieser Wert ist keine gültige URL.',
    'The two values should be equal.' => 'Die beiden Werte sollten identisch sein.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'Die Datei ist zu groß. Die maximal zulässige Größe beträgt {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'Die Datei ist zu groß.',
    'The file could not be uploaded.' => 'Die Datei konnte nicht hochgeladen werden.',
    'This value should be a valid number.' => 'Dieser Wert sollte eine gültige Zahl sein.',
    'This file is not a valid image.' => 'Diese Datei ist kein gültiges Bild.',
    'This is not a valid IP address.' => 'Dies ist keine gültige IP-Adresse.',
    'This value is not a valid language.' => 'Dieser Wert entspricht keiner gültigen Sprache.',
    'This value is not a valid locale.' => 'Dieser Wert entspricht keinem gültigen Gebietsschema.',
    'This value is not a valid country.' => 'Dieser Wert entspricht keinem gültigen Land.',
    'This value is already used.' => 'Dieser Wert wird bereits verwendet.',
    'The size of the image could not be detected.' => 'Die Größe des Bildes konnte nicht ermittelt werden.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'Die Bildbreite ist zu groß ({{ width }}px). Die maximal zulässige Breite beträgt {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'Die Bildbreite ist zu gering ({{ width }}px). Die erwartete Mindestbreite beträgt {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'Die Bildhöhe ist zu groß ({{ height }}px). Die maximal zulässige Höhe beträgt {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'Die Bildhöhe ist zu gering ({{ height }}px). Die erwartete Mindesthöhe beträgt {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'Dieser Wert sollte dem aktuellen Benutzerpasswort entsprechen.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'Dieser Wert sollte genau {{ limit }} Zeichen lang sein.|Dieser Wert sollte genau {{ limit }} Zeichen lang sein.',
    'The file was only partially uploaded.' => 'Die Datei wurde nur teilweise hochgeladen.',
    'No file was uploaded.' => 'Es wurde keine Datei hochgeladen.',
    'No temporary folder was configured in php.ini.' => 'Es wurde kein temporärer Ordner in der php.ini konfiguriert oder der temporäre Ordner existiert nicht.',
    'Cannot write temporary file to disk.' => 'Kann die temporäre Datei nicht speichern.',
    'A PHP extension caused the upload to fail.' => 'Eine PHP-Erweiterung verhinderte den Upload.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'Diese Sammlung sollte {{ limit }} oder mehr Elemente beinhalten.|Diese Sammlung sollte {{ limit }} oder mehr Elemente beinhalten.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'Diese Sammlung sollte {{ limit }} oder weniger Elemente beinhalten.|Diese Sammlung sollte {{ limit }} oder weniger Elemente beinhalten.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'Diese Sammlung sollte genau {{ limit }} Element beinhalten.|Diese Sammlung sollte genau {{ limit }} Elemente beinhalten.',
    'Invalid card number.' => 'Ungültige Kartennummer.',
    'Unsupported card type or invalid card number.' => 'Nicht unterstützter Kartentyp oder ungültige Kartennummer.',
    'This is not a valid International Bank Account Number (IBAN).' => 'Dieser Wert ist keine gültige internationale Bankkontonummer (IBAN).',
    'This value is not a valid ISBN-10.' => 'Dieser Wert entspricht keiner gültigen ISBN-10.',
    'This value is not a valid ISBN-13.' => 'Dieser Wert entspricht keiner gültigen ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'Dieser Wert ist weder eine gültige ISBN-10 noch eine gültige ISBN-13.',
    'This value is not a valid ISSN.' => 'Dieser Wert ist keine gültige ISSN.',
    'This value is not a valid currency.' => 'Dieser Wert ist keine gültige Währung.',
    'This value should be equal to {{ compared_value }}.' => 'Dieser Wert sollte gleich {{ compared_value }} sein.',
    'This value should be greater than {{ compared_value }}.' => 'Dieser Wert sollte größer als {{ compared_value }} sein.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'Dieser Wert sollte größer oder gleich {{ compared_value }} sein.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Dieser Wert sollte identisch sein mit {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'Dieser Wert sollte kleiner als {{ compared_value }} sein.',
    'This value should be less than or equal to {{ compared_value }}.' => 'Dieser Wert sollte kleiner oder gleich {{ compared_value }} sein.',
    'This value should not be equal to {{ compared_value }}.' => 'Dieser Wert sollte nicht {{ compared_value }} sein.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'Dieser Wert sollte nicht identisch sein mit {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'Das Seitenverhältnis des Bildes ist zu groß ({{ ratio }}). Der erlaubte Maximalwert ist {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'Das Seitenverhältnis des Bildes ist zu klein ({{ ratio }}). Der erwartete Minimalwert ist {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'Das Bild ist quadratisch ({{ width }}x{{ height }}px). Quadratische Bilder sind nicht erlaubt.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'Das Bild ist im Querformat ({{ width }}x{{ height }}px). Bilder im Querformat sind nicht erlaubt.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'Das Bild ist im Hochformat ({{ width }}x{{ height }}px). Bilder im Hochformat sind nicht erlaubt.',
    'An empty file is not allowed.' => 'Eine leere Datei ist nicht erlaubt.',
    'The host could not be resolved.' => 'Der Hostname konnte nicht aufgelöst werden.',
    'This value does not match the expected {{ charset }} charset.' => 'Dieser Wert entspricht nicht dem erwarteten Zeichensatz {{ charset }}.',
    'This is not a valid Business Identifier Code (BIC).' => 'Dieser Wert ist keine gültige internationale Bankleitzahl (BIC).',
    'Error' => 'Fehler',
    'This is not a valid UUID.' => 'Dies ist keine gültige UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'Dieser Wert sollte ein Vielfaches von {{ compared_value }} sein.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'Diese internationale Bankleitzahl (BIC) ist nicht mit der IBAN {{ iban }} assoziiert.',
    'This value should be valid JSON.' => 'Dieser Wert sollte gültiges JSON sein.',
    'This collection should contain only unique elements.' => 'Diese Sammlung darf keine doppelten Elemente enthalten.',
    'This value should be positive.' => 'Diese Zahl sollte positiv sein.',
    'This value should be either positive or zero.' => 'Diese Zahl sollte entweder positiv oder 0 sein.',
    'This value should be negative.' => 'Diese Zahl sollte negativ sein.',
    'This value should be either negative or zero.' => 'Diese Zahl sollte entweder negativ oder 0 sein.',
    'This value is not a valid timezone.' => 'Dieser Wert ist keine gültige Zeitzone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'Dieses Passwort ist Teil eines Datenlecks, es darf nicht verwendet werden.',
    'This value should be between {{ min }} and {{ max }}.' => 'Dieser Wert sollte zwischen {{ min }} und {{ max }} sein.',
    'This value is not a valid hostname.' => 'Dieser Wert ist kein gültiger Hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'Die Anzahl an Elementen in dieser Sammlung sollte ein Vielfaches von {{ compared_value }} sein.',
    'This value should satisfy at least one of the following constraints:' => 'Dieser Wert sollte eine der folgenden Bedingungen erfüllen:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Jedes Element dieser Sammlung sollte seine eigene Menge an Bedingungen erfüllen.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'Dieser Wert ist keine gültige Internationale Wertpapierkennnummer (ISIN).',
    'This value should be a valid expression.' => 'Dieser Wert sollte eine gültige Expression sein.',
    'This value is not a valid CSS color.' => 'Dieser Wert ist keine gültige CSS-Farbe.',
    'This value is not a valid CIDR notation.' => 'Dieser Wert entspricht nicht der CIDR-Notation.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'Der Wert der Subnetzmaske sollte zwischen {{ min }} und {{ max }} liegen.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'Der Dateiname ist zu lang. Er sollte nicht länger als {{ filename_max_length }} Zeichen sein.|Der Dateiname ist zu lang. Er sollte nicht länger als {{ filename_max_length }} Zeichen sein.',
    'This form should not contain extra fields.' => 'Dieses Formular sollte keine zusätzlichen Felder enthalten.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'Die hochgeladene Datei ist zu groß. Versuchen Sie bitte eine kleinere Datei hochzuladen.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'Der CSRF-Token ist ungültig. Versuchen Sie bitte, das Formular erneut zu senden.',
    'This value is not a valid HTML5 color.' => 'Dieser Wert ist keine gültige HTML5 Farbe.',
    'Please enter a valid birthdate.' => 'Bitte geben Sie ein gültiges Geburtsdatum ein.',
    'The selected choice is invalid.' => 'Die Auswahl ist ungültig.',
    'The collection is invalid.' => 'Diese Gruppe von Feldern ist ungültig.',
    'Please select a valid color.' => 'Bitte geben Sie eine gültige Farbe ein.',
    'Please select a valid country.' => 'Bitte wählen Sie ein gültiges Land aus.',
    'Please select a valid currency.' => 'Bitte wählen Sie eine gültige Währung aus.',
    'Please choose a valid date interval.' => 'Bitte wählen Sie ein gültiges Datumsintervall.',
    'Please enter a valid date and time.' => 'Bitte geben Sie ein gültiges Datum samt Uhrzeit ein.',
    'Please enter a valid date.' => 'Bitte geben Sie ein gültiges Datum ein.',
    'Please select a valid file.' => 'Bitte wählen Sie eine gültige Datei.',
    'The hidden field is invalid.' => 'Das versteckte Feld ist ungültig.',
    'Please enter an integer.' => 'Bitte geben Sie eine ganze Zahl ein.',
    'Please select a valid language.' => 'Bitte wählen Sie eine gültige Sprache.',
    'Please select a valid locale.' => 'Bitte wählen Sie eine gültige Locale-Einstellung aus.',
    'Please enter a valid money amount.' => 'Bitte geben Sie einen gültigen Geldbetrag ein.',
    'Please enter a number.' => 'Bitte geben Sie eine gültige Zahl ein.',
    'The password is invalid.' => 'Das Kennwort ist ungültig.',
    'Please enter a percentage value.' => 'Bitte geben Sie einen gültigen Prozentwert ein.',
    'The values do not match.' => 'Die Werte stimmen nicht überein.',
    'Please enter a valid time.' => 'Bitte geben Sie eine gültige Uhrzeit ein.',
    'Please select a valid timezone.' => 'Bitte wählen Sie eine gültige Zeitzone.',
    'Please enter a valid URL.' => 'Bitte geben Sie eine gültige URL ein.',
    'Please enter a valid search term.' => 'Bitte geben Sie einen gültigen Suchbegriff ein.',
    'Please provide a valid phone number.' => 'Bitte geben Sie eine gültige Telefonnummer ein.',
    'The checkbox has an invalid value.' => 'Das Kontrollkästchen hat einen ungültigen Wert.',
    'Please enter a valid email address.' => 'Bitte geben Sie eine gültige E-Mail-Adresse ein.',
    'Please select a valid option.' => 'Bitte wählen Sie eine gültige Option.',
    'Please select a valid range.' => 'Bitte wählen Sie einen gültigen Bereich.',
    'Please enter a valid week.' => 'Bitte geben Sie eine gültige Woche ein.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'Es ist ein Fehler bei der Authentifikation aufgetreten.',
    'Authentication credentials could not be found.' => 'Es konnten keine Zugangsdaten gefunden werden.',
    'Authentication request could not be processed due to a system problem.' => 'Die Authentifikation konnte wegen eines Systemproblems nicht bearbeitet werden.',
    'Invalid credentials.' => 'Fehlerhafte Zugangsdaten.',
    'Cookie has already been used by someone else.' => 'Cookie wurde bereits von jemand anderem verwendet.',
    'Not privileged to request the resource.' => 'Keine Rechte, um die Ressource anzufragen.',
    'Invalid CSRF token.' => 'Ungültiges CSRF-Token.',
    'No authentication provider found to support the authentication token.' => 'Es wurde kein Authentifizierungs-Provider gefunden, der das Authentifizierungs-Token unterstützt.',
    'No session available, it either timed out or cookies are not enabled.' => 'Keine Session verfügbar, entweder ist diese abgelaufen oder Cookies sind nicht aktiviert.',
    'No token could be found.' => 'Es wurde kein Token gefunden.',
    'Username could not be found.' => 'Der Benutzername wurde nicht gefunden.',
    'Account has expired.' => 'Der Account ist abgelaufen.',
    'Credentials have expired.' => 'Die Zugangsdaten sind abgelaufen.',
    'Account is disabled.' => 'Der Account ist deaktiviert.',
    'Account is locked.' => 'Der Account ist gesperrt.',
    'Too many failed login attempts, please try again later.' => 'Zu viele fehlgeschlagene Anmeldeversuche, bitte versuchen Sie es später noch einmal.',
    'Invalid or expired login link.' => 'Ungültiger oder abgelaufener Anmelde-Link.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Zu viele fehlgeschlagene Anmeldeversuche, bitte versuchen Sie es in einer Minute noch einmal.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Zu viele fehlgeschlagene Anmeldeversuche, bitte versuchen Sie es in %minutes% Minuten noch einmal.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Vorherige',
    'label_next' => 'Nächste',
    'filter_searchword' => 'Suchbegriff...',
  ),
  'messages' => 
  array (
    'Signed in as' => 'Angemeldet als',
    'Your Profile' => 'Dein Profil',
    'Create Ticket' => 'Ticket erstellen',
    'Create Agent' => 'Agent erstellen',
    'Create Customer' => 'Kunden erstellen',
    'Sign Out' => 'Abmelden',
    'Default Language (Optional)' => 'Standardsprache (optional)',
    'Username/Email' => 'Benutzername/E-Mail',
    'create new' => 'Erstelle neu',
    'Howdy!' => 'Hallo!',
    'Ticket Information' => 'Ticketinformation',
    'CC/BCC' => 'CC/BCC',
    'Success! Label created successfully.' => 'Erfolg! Label erfolgreich erstellt.',
    'Success! Label removed successfully.' => 'Erfolg! Label erfolgreich entfernt.',
    'Reports' => 'Berichte',
    'Rating' => 'Bewertung',
    'Kudos Rating' => 'Kudos-Bewertung',
    'Choose your default timeformat' => 'Wählen Sie Ihr Standardzeitformat',
    'Remove profile picture' => 'Profilbild entfernen',
    'Success ! Profile updated successfully.' => 'Erfolg ! Profil erfolgreich aktualisiert.',
    'Howdy' => 'Hallo',
    'Form successfully updated.' => 'Formular erfolgreich aktualisiert.',
    'NEW FORM' => 'NEUE FORM',
    'Text Box' => 'Textfeld',
    'Text Area' => 'Textbereich',
    'Select' => 'Auswählen',
    'Radio' => 'Radio',
    'Checkbox' => 'Kontrollkästchen',
    'Date' => 'Datum',
    'Both Date and Time' => 'Datum und Uhrzeit',
    'Choose a status' => 'Wähle einen Status',
    'Choose a group' => 'Wähle eine Gruppe',
    'Can manage Group\'s Saved Reply' => 'Kann die gespeicherte Antwort der Gruppe verwalten',
    'Can manage agent activity' => 'Kann Agentenaktivitäten verwalten',
    'Slug is the url identity of this article. We will help you to create valid slug at time of typing.' => 'Slug ist die URL-Identität dieses Artikels. Wir helfen Ihnen beim Erstellen eines gültigen Slugs zum Zeitpunkt der Eingabe.',
    'The URL for this article' => 'Die URL für diesen Artikel',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A page\'s title tag and meta description are usually shown whenever that page appears in search engine results' => 'Titel-Tags und Meta-Beschreibungen sind Teile des HTML-Codes im Header einer Webseite. Sie helfen Suchmaschinen, den Inhalt einer Seite zu verstehen. Der Titel-Tag und die Meta-Beschreibung einer Seite werden normalerweise angezeigt, wenn diese Seite in den Suchmaschinenergebnissen erscheint',
    'comma separated (,)' => 'Komma getrennt (,)',
    'Article Title' => 'Artikelüberschrift',
    'Start typing few charactors and add set of relevant article from the list' => 'Beginnen Sie mit der Eingabe weniger Zeichen und fügen Sie einen Satz relevanter Artikel aus der Liste hinzu',
    'Success! Announcement data saved successfully.' => 'Erfolg! Ansagedaten erfolgreich gespeichert.',
    'Success! Category has been added successfully.' => 'Erfolg! Kategorie wurde erfolgreich hinzugefügt.',
    'Success ! Agent added successfully.' => 'Erfolg ! Agent erfolgreich hinzugefügt.',
    'Success! Privilege information saved successfully.' => 'Erfolg! Berechtigungsinformationen erfolgreich gespeichert.',
    'Edit Prepared Response' => 'Vorbereitete Antwort bearbeiten',
    'Success! Type removed successfully.' => 'Erfolg! Typ erfolgreich entfernt.',
    'No results available' => 'Keine Ergebnisse verfügbar',
    'Success ! Prepared Response applied successfully.' => 'Erfolg ! Vorbereitete Antwort erfolgreich angewendet.',
    'Note added to ticket successfully.' => 'Notiz erfolgreich zum Ticket hinzugefügt.',
    'Ticket status update to Spam' => 'Ticket-Status-Update zu Spam',
    'Ticket status update to Closed' => 'Aktualisierung des Ticketstatus auf „Geschlossen“.',
    'Success! Label updated successfully.' => 'Erfolg! Label erfolgreich aktualisiert.',
    'Success ! Helpdesk details saved successfully' => 'Erfolg ! Helpdesk-Details erfolgreich gespeichert',
    'Can manage marketing announcement' => 'Kann Marketingmitteilungen verwalten',
    'User Forgot Password' => 'Benutzer Passwort vergessen',
    'Agent Deleted' => 'Agent gelöscht',
    'Agent Update' => 'Agenten-Update',
    'Customer Update' => 'Kunden-Update',
    'Customer Deleted' => 'Kunde gelöscht',
    'Agent Updated' => 'Agent aktualisiert',
    'Agent Reply' => 'Agentenantwort',
    'Collaborator Added' => 'Mitarbeiter hinzugefügt',
    'Collaborator Reply' => 'Mitarbeiterantwort',
    'Customer Reply' => 'Kundenantwort',
    'Ticket Deleted' => 'Ticket gelöscht',
    'Group Updated' => 'Gruppe aktualisiert',
    'Note Added' => 'Hinweis hinzugefügt',
    'Priority Updated' => 'Priorität aktualisiert',
    'Status Updated' => 'Status aktualisiert',
    'Team Updated' => 'Team aktualisiert',
    'Thread Updated' => 'Thema aktualisiert',
    'Type Updated' => 'Typ aktualisiert',
    'From Email' => 'Aus der Email',
    'To Email' => 'Eine E-Mail schicken',
    'Is Equal To' => 'Ist gleich',
    'Is Not Equal To' => 'Ist ungleich zu',
    'Contains' => 'Enthält',
    'Does Not Contain' => 'Beinhaltet nicht',
    'Starts With' => 'Beginnt mit',
    'Ends With' => 'Endet mit',
    'Before On' => 'Vor Ein',
    'After On' => 'Nach Ein',
    'Mail To User' => 'Mail an Benutzer',
    'Permanently delete from Inbox' => 'Endgültig aus Posteingang löschen',
    'Transfer Tickets' => 'Transfertickets',
    'Agent Activity' => 'Agentenaktivität',
    'Report From' => 'Bericht von',
    'Search Agent' => 'Suchagent',
    'Agent Last Reply' => 'Agent Letzte Antwort',
    'View analytics and insights to serve a better experience for your customers' => 'Zeigen Sie Analysen und Erkenntnisse an, um Ihren Kunden ein besseres Erlebnis zu bieten',
    'Marketing Announcement' => 'Marketing-Ankündigung',
    'Advertisment' => 'Werbung',
    'Announcement' => 'Bekanntmachung',
    'New Announcement' => 'Neue Ankündigung',
    'Add Announcement' => 'Ankündigung hinzufügen',
    'Edit Announcement' => 'Ankündigung bearbeiten',
    'Promo Text' => 'Promo-Text',
    'Promo Tag' => 'Promo-Tag',
    'Choose a promo tag' => 'Wählen Sie ein Promo-Tag',
    'Tag-Color' => 'Tag-Farbe',
    'Tag background color' => 'Tag Hintergrundfarbe',
    'Link Text' => 'Link Text',
    'Link URL' => 'URL verknüpfen',
    'Apps' => 'Apps',
    'Integrate apps as per your needs to get things done faster than ever' => 'Integrieren Sie Apps nach Ihren Wünschen, um die Dinge schneller als je zuvor zu erledigen.',
    'Explore Apps' => 'Apps erkunden',
    'Form Builder' => 'Form Builder',
    'Knowledgebase' => 'Wissensbasis',
    'Knowledgebase is a source of rigid and complex information which helps Customers to help themselves' => 'Wissensbasis ist eine Quelle komplexer Informationen, die den Kunden hilft, sich selbständig zu helfen.',
    'Articles' => 'Artikel',
    'Categories' => 'Kategorien',
    'Folders' => 'Ordner',
    'FOLDERS' => 'ORDNER',
    'Productivity' => 'Produktivität',
    'Automate your processes by creating set of rules and presets to respond faster to the tickets' => 'Automatisieren Sie Ihre Prozesse, indem Sie eine Reihe von Regeln und Vorgaben erstellen, um schneller auf die Tickets zu reagieren.',
    'Prepared Responses' => 'Vorbereitete Antworten',
    'Saved Replies' => 'Gespeicherte Antworten',
    'Edit Saved Reply' => 'Gespeicherte Antwort bearbeiten',
    'Ticket Types' => 'Ticket-Typen',
    'Workflows' => 'Workflows',
    'Settings' => 'Einstellungen',
    'Manage your Brand Identity, Company Information and other details at a glance' => 'Verwalten der Markenidentität, Unternehmensinformationen und anderer Details auf einen Blick',
    'Branding' => 'Markenbildung',
    'Custom Fields' => 'Benutzerdefinierte Felder',
    'Email Settings' => 'E-Mail-Einstellungen',
    'Email Templates' => 'E-Mail-Vorlagen',
    'Mailbox' => 'Mailbox',
    'Spam Settings' => 'Spam-Einstellungen',
    'Swift Mailer' => 'Swift Mailer',
    'Tags' => 'Stichwörter',
    'Users' => 'Benutzer',
    'Control your Groups, Teams, Agents and Customers' => 'Verwalten der Gruppen, Teams, Agenten und Kunden',
    'Agents' => 'Agenten',
    'Customers' => 'Kunden',
    'Groups' => 'Gruppen',
    'Privileges' => 'Berechtigungen',
    'Teams' => 'Teams',
    'Applications' => 'Anwendungen',
    'ECommerce Order Syncronization' => 'ECommerce Folder Synchronization',
    'Import ecommerce order details to your support tickets from different available platforms' => 'Importieren Sie E-Commerce-Bestelldetails von verschiedenen verfügbaren Plattformen in Ihre Support-Tickets.',
    'Search' => 'Suche',
    'Sort By' => 'Sortieren nach',
    'Sort By:' => 'Sortieren nach:',
    'Status' => 'Status',
    'Created At' => 'Hergestellt in',
    'Name' => 'Name',
    'All' => 'Alle',
    'Published' => 'Veröffentlicht',
    'Draft' => 'Entwurf',
    'New Folder' => 'Neuer Ordner',
    'Create Knowledgebase Folder' => 'Wissensbasis-Ordner erstellen',
    'You did not add any folder to your Knowledgebase yet, Create your first Folder and start adding Categories/Articles to make your customers help themselves.' => 'Sie haben noch keinen Ordner zu Ihrer Wissensbasis hinzugefügt. Erstellen Sie Ihren ersten Ordner und fügen Sie Kategorien / Artikel hinzu, damit Ihre Kunden sich selbst helfen können.',
    'Clear Filters' => 'Filter zurücksetzen',
    'Back' => 'Zurück',
    'Open' => 'Offen (open)',
    'Pending' => 'Ausstehend (pending)',
    'Answered' => 'Beantwortet (answered)',
    'Resolved' => 'Erledigt (resolved)',
    'Closed' => 'Geschlossen (closed)',
    'Spam' => 'Spam',
    'New' => 'Neu',
    'UnAssigned' => 'Nicht zugewiesen',
    'UnAnswered' => 'Unbeantwortet',
    'My Tickets' => 'Meine Tickets',
    'Starred' => 'Markiert',
    'Trashed' => 'im Papierkorb',
    'New Label' => 'Neues Label',
    'Tickets' => 'Tickets',
    'Ticket Id' => 'Ticket-ID',
    'Last Replied' => 'Letzte Antwort',
    'Assign To' => 'Zuweisen',
    'After Reply' => 'Nach der Antwort',
    'Customer Email' => 'E-Mail',
    'Customer Name' => 'Kunde',
    'Assets Visibility' => 'Sichtbarkeit von Assets',
    'Channel/Source' => 'Kanal / Quelle',
    'Channel' => 'Kanal',
    'Website' => 'Webseite',
    'Timestamp' => 'Zeitstempel',
    'TimeStamp' => 'Zeitstempel',
    'Team' => 'Team',
    'Type' => 'Typ',
    'Replies' => 'Antworten',
    'Agent' => 'Agent',
    'ID' => 'ID',
    'Subject' => 'Betreff',
    'Last Reply' => 'Letzte Antwort',
    'Filter View' => 'Filteransicht',
    'Please select CAPTCHA' => 'Bitte wählen Sie CAPTCHA',
    'Warning ! Please select correct CAPTCHA !' => 'Warnung! Bitte wählen Sie das richtige CAPTCHA!',
    'reCAPTCHA Setting' => 'reCAPTCHA-Einstellung',
    'reCAPTCHA Site Key' => 'reCAPTCHA Site Key',
    'reCAPTCHA Secret key' => 'reCAPTCHA Geheimer Schlüssel',
    'reCAPTCHA Status' => 'reCAPTCHA-Status',
    'reCAPTCHA is Active' => 'reCAPTCHA ist aktiv',
    'Save set of filters as a preset to stay more productive' => 'Filter als Voreinstellung speichern',
    'Saved Filters' => 'Gespeicherte Filter',
    'No saved filter created' => 'Kein gespeicherter Filter erstellt',
    'Customer' => 'Kunde',
    'Priority' => 'Priorität',
    'Tag' => 'Etikett',
    'Source' => 'Quelle',
    'Before' => 'Vor',
    'After' => 'Nach',
    'Replies less than' => 'Antworten weniger als',
    'Replies more than' => 'Antworten mehr als',
    'Clear All' => 'Alles löschen',
    'Account' => 'Konto',
    'Profile' => 'Profil',
    'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format' => 'Hochladen eines Profilbilds (100 x 100 Pixel) im PNG- oder JPG-Format',
    'First Name' => 'Vorname',
    'Last Name' => 'Nachname',
    'Email' => 'E-Mail',
    'Contact Number' => 'Kontakt Nummer',
    'Timezone' => 'Zeitzone',
    'Africa/Abidjan' => 'Afrika / Abidjan',
    'Africa/Accra' => 'Afrika / Accra',
    'Africa/Addis_Ababa' => 'Afrika / Addis_Ababa',
    'Africa/Algiers' => 'Afrika / Algier',
    'Africa/Asmara' => 'Afrika / Asmara',
    'Africa/Bamako' => 'Afrika / Bamako',
    'Africa/Bangui' => 'Afrika / Bangui',
    'Africa/Banjul' => 'Afrika / Banjul',
    'Africa/Bissau' => 'Afrika / Bissau',
    'Africa/Blantyre' => 'Afrika / Blantyre',
    'Africa/Brazzaville' => 'Afrika / Brazzaville',
    'Africa/Bujumbura' => 'Afrika / Bujumbura',
    'Africa/Cairo' => 'Afrika / Kairo',
    'Africa/Casablanca' => 'Afrika / Casablanca',
    'Africa/Ceuta' => 'Afrika / Ceuta',
    'Africa/Conakry' => 'Afrika / Conakry',
    'Africa/Dakar' => 'Afrika / Dakar',
    'Africa/Dar_es_Salaam' => 'Afrika / Dar_es_Salaam',
    'Africa/Djibouti' => 'Afrika / Dschibuti',
    'Africa/Douala' => 'Afrika / Douala',
    'Africa/El_Aaiun' => 'Afrika / El_Aaiun',
    'Africa/Freetown' => 'Afrika / Freetown',
    'Africa/Gaborone' => 'Afrika / Gaborone',
    'Africa/Harare' => 'Afrika / Harare',
    'Africa/Johannesburg' => 'Afrika / Johannesburg',
    'Africa/Juba' => 'Afrika / Juba',
    'Africa/Kampala' => 'Afrika / Kampala',
    'Africa/Khartoum' => 'Afrika / Khartoum',
    'Africa/Kigali' => 'Afrika / Kigali',
    'Africa/Kinshasa' => 'Afrika / Kinshasa',
    'Africa/Lagos' => 'Afrika / Lagos',
    'Africa/Libreville' => 'Afrika / Libreville',
    'Africa/Lome' => 'Afrika / Lome',
    'Africa/Luanda' => 'Afrika / Luanda',
    'Africa/Lubumbashi' => 'Afrika / Lubumbashi',
    'Africa/Lusaka' => 'Afrika / Lusaka',
    'Africa/Malabo' => 'Afrika / Malabo',
    'Africa/Maputo' => 'Afrika / Maputo',
    'Africa/Maseru' => 'Afrika / Maseru',
    'Africa/Mbabane' => 'Afrika / Mbabane',
    'Africa/Mogadishu' => 'Afrika / Mogadischu',
    'Africa/Monrovia' => 'Afrika / Monrovia',
    'Africa/Nairobi' => 'Afrika / Nairobi',
    'Africa/Ndjamena' => 'Afrika / Ndjamena',
    'Africa/Niamey' => 'Afrika / Niamey',
    'Africa/Nouakchott' => 'Afrika / Nouakchott',
    'Africa/Ouagadougou' => 'Afrika / Ouagadougou',
    'Africa/Porto-Novo' => 'Afrika / Porto-Novo',
    'Africa/Sao_Tome' => 'Afrika / Sao_Tome',
    'Africa/Tripoli' => 'Afrika / Tripoli',
    'Africa/Tunis' => 'Afrika / Tunis',
    'Africa/Windhoek' => 'Afrika / Windhoek',
    'America/Adak' => 'Amerika / Adak',
    'America/Anchorage' => 'Amerika / Anchorage',
    'America/Anguilla' => 'Amerika / Anguilla',
    'America/Antigua' => 'Amerika / Antigua',
    'America/Araguaina' => 'Amerika / Araguaina',
    'America/Argentina/Buenos_Aires' => 'Amerika / Argentinien / Buenos_Aires',
    'America/Argentina/Catamarca' => 'Amerika / Argentinien / Catamarca',
    'America/Argentina/Cordoba' => 'Amerika / Argentinien / Cordoba',
    'America/Argentina/Jujuy' => 'Amerika / Argentinien / Jujuy',
    'America/Argentina/La_Rioja' => 'Amerika / Argentinien / La Rioja',
    'America/Argentina/Mendoza' => 'Amerika / Argentinien / Mendoza',
    'America/Argentina/Rio_Gallegos' => 'Amerika / Argentinien / Rio_Gallegos',
    'America/Argentina/Salta' => 'Amerika / Argentinien / Salta',
    'America/Argentina/San_Juan' => 'Amerika / Argentinien / San Juan',
    'America/Argentina/San_Luis' => 'Amerika / Argentinien / San Luis',
    'America/Argentina/Tucuman' => 'Amerika / Argentinien / Tucuman',
    'America/Argentina/Ushuaia' => 'Amerika / Argentinien / Ushuaia',
    'America/Aruba' => 'Amerika / Aruba',
    'America/Asuncion' => 'Amerika / Asuncion',
    'America/Atikokan' => 'Amerika / Atikokan',
    'America/Bahia' => 'Amerika / Bahia',
    'America/Bahia_Banderas' => 'Amerika / Bahia_Banderas',
    'America/Barbados' => 'Amerika / Barbados',
    'America/Belem' => 'Amerika / Belem',
    'America/Belize' => 'Amerika / Belize',
    'America/Blanc-Sablon' => 'Amerika / Blanc-Sablon',
    'America/Boa_Vista' => 'Amerika / Boa_Vista',
    'America/Bogota' => 'Amerika / Bogota',
    'America/Boise' => 'Amerika / Boise',
    'America/Cambridge_Bay' => 'Amerika / Cambridge_Bay',
    'America/Campo_Grande' => 'Amerika / Campo_Grande',
    'America/Cancun' => 'Amerika / Cancun',
    'America/Caracas' => 'Amerika / Caracas',
    'America/Cayenne' => 'Amerika / Cayenne',
    'America/Cayman' => 'Amerika / Cayman',
    'America/Chicago' => 'Amerika / Chicago',
    'America/Chihuahua' => 'Amerika / Chihuahua',
    'America/Costa_Rica' => 'Amerika / Costa_Rica',
    'America/Creston' => 'Amerika / Creston',
    'America/Cuiaba' => 'Amerika / Cuiaba',
    'America/Curacao' => 'Amerika / Curaçao',
    'America/Danmarkshavn' => 'Amerika / Danmarkshavn',
    'America/Dawson' => 'Amerika / Dawson',
    'America/Dawson_Creek' => 'Amerika / Dawson_Creek',
    'America/Denver' => 'Amerika / Denver',
    'America/Detroit' => 'Amerika / Detroit',
    'America/Dominica' => 'Amerika / Dominica',
    'America/Edmonton' => 'Amerika / Edmonton',
    'America/Eirunepe' => 'Amerika / Eirunepe',
    'America/El_Salvador' => 'Amerika / El_Salvador',
    'America/Fort_Nelson' => 'Amerika / Fort Nelson',
    'America/Fortaleza' => 'Amerika / Fortaleza',
    'America/Glace_Bay' => 'Amerika / Glace_Bay',
    'America/Godthab' => 'Amerika / Godthab',
    'America/Goose_Bay' => 'Amerika / Goose_Bay',
    'America/Grand_Turk' => 'Amerika / Grand_Turk',
    'America/Grenada' => 'Amerika / Grenada',
    'America/Guadeloupe' => 'Amerika / Guadeloupe',
    'America/Guatemala' => 'Amerika / Guatemala',
    'America/Guayaquil' => 'Amerika / Guayaquil',
    'America/Guyana' => 'Amerika / Guyana',
    'America/Halifax' => 'Amerika / Halifax',
    'America/Havana' => 'Amerika / Havanna',
    'America/Hermosillo' => 'Amerika / Hermosillo',
    'America/Indiana/Indianapolis' => 'Amerika / Indiana / Indianapolis',
    'America/Indiana/Knox' => 'Amerika / Indiana / Knox',
    'America/Indiana/Marengo' => 'Amerika / Indiana / Marengo',
    'America/Indiana/Petersburg' => 'Amerika / Indiana / Petersburg',
    'America/Indiana/Tell_City' => 'Amerika / Indiana / Tell_City',
    'America/Indiana/Vevay' => 'Amerika / Indiana / Vevay',
    'America/Indiana/Vincennes' => 'Amerika / Indiana / Vincennes',
    'America/Indiana/Winamac' => 'Amerika / Indiana / Winamac',
    'America/Inuvik' => 'Amerika / Inuvik',
    'America/Iqaluit' => 'Amerika / Iqaluit',
    'America/Jamaica' => 'Amerika / Jamaika',
    'America/Juneau' => 'Amerika / Juneau',
    'America/Kentucky/Louisville' => 'Amerika / Kentucky / Louisville',
    'America/Kentucky/Monticello' => 'Amerika / Kentucky / Monticello',
    'America/Kralendijk' => 'Amerika / Kralendijk',
    'America/La_Paz' => 'Amerika / La_Paz',
    'America/Lima' => 'Amerika / Lima',
    'America/Los_Angeles' => 'Amerika / Los_Angeles',
    'America/Lower_Princes' => 'Amerika / Lower_Princes',
    'America/Maceio' => 'Amerika / Maceio',
    'America/Managua' => 'Amerika / Managua',
    'America/Manaus' => 'Amerika / Manaus',
    'America/Marigot' => 'Amerika / Marigot',
    'America/Martinique' => 'Amerika / Martinique',
    'America/Matamoros' => 'Amerika / Matamoros',
    'America/Mazatlan' => 'Amerika / Mazatlan',
    'America/Menominee' => 'Amerika / Menominee',
    'America/Merida' => 'Amerika / Merida',
    'America/Metlakatla' => 'Amerika / Metlakatla',
    'America/Mexico_City' => 'Amerika / Mexico_City',
    'America/Miquelon' => 'Amerika / Miquelon',
    'America/Moncton' => 'Amerika / Moncton',
    'America/Monterrey' => 'Amerika / Monterrey',
    'America/Montevideo' => 'Amerika / Montevideo',
    'America/Montserrat' => 'Amerika / Montserrat',
    'America/Nassau' => 'Amerika / Nassau',
    'America/New_York' => 'Amerika / New_York',
    'America/Nipigon' => 'Amerika / Nipigon',
    'America/Nome' => 'Amerika / Nome',
    'America/Noronha' => 'Amerika / Noronha',
    'America/North_Dakota/Beulah' => 'Amerika / North Dakota / Beulah',
    'America/North_Dakota' => 'Amerika / North_Dakota',
    'America/Ojinaga' => 'Amerika / Ojinaga',
    'America/Panama' => 'Amerika / Panama',
    'America/Pangnirtung' => 'Amerika / Pangnirtung',
    'America/Paramaribo' => 'Amerika / Paramaribo',
    'America/Phoenix' => 'Amerika / Phoenix',
    'America/Port-au-Prince' => 'Amerika / Port-au-Prince',
    'America/Port_of_Spain' => 'Amerika / Port_of_Spain',
    'America/Porto_Velho' => 'Amerika / Porto_Velho',
    'America/Puerto_Rico' => 'Amerika / Puerto Rico',
    'America/Punta_Arenas' => 'Amerika / Punta_Arenas',
    'America/Rainy_River' => 'Amerika / Rainy_River',
    'America/Rankin_Inlet' => 'Amerika / Rankin_Inlet',
    'America/Recife' => 'Amerika / Recife',
    'America/Regina' => 'Amerika / Regina',
    'America/Resolute' => 'Amerika / Resolute',
    'America/Rio_Branco' => 'Amerika / Rio_Branco',
    'America/Santarem' => 'Amerika / Santarem',
    'America/Santiago' => 'Amerika / Santiago',
    'America/Santo_Domingo' => 'Amerika / Santo_Domingo',
    'America/Sao_Paulo' => 'Amerika / Sao_Paulo',
    'America/Scoresbysund' => 'Amerika / Scoresbysund',
    'America/Sitka' => 'Amerika / Sitka',
    'America/St_Barthelemy' => 'Amerika / St_Barthelemy',
    'America/St_Johns' => 'Amerika / St_Johns',
    'America/St_Kitts' => 'Amerika / St_Kitts',
    'America/St_Lucia' => 'Amerika / St_Lucia',
    'America/St_Thomas' => 'Amerika / St_Thomas',
    'America/St_Vincent' => 'Amerika / St_Vincent',
    'America/Swift_Current' => 'Amerika / Swift_Current',
    'America/Tegucigalpa' => 'Amerika / Tegucigalpa',
    'America/Thule' => 'Amerika / Thule',
    'America/Thunder_Bay' => 'Amerika / Thunder_Bay',
    'America/Tijuana' => 'Amerika / Tijuana',
    'America/Toronto' => 'Amerika / Toronto',
    'America/Tortola' => 'Amerika / Tortola',
    'America/Vancouver' => 'Amerika / Vancouver',
    'America/Whitehorse' => 'Amerika / Whitehorse',
    'America/Winnipeg' => 'Amerika / Winnipeg',
    'America/Yakutat' => 'Amerika / Yakutat',
    'America/Yellowknife' => 'Amerika / Yellowknife',
    'Antarctica/Casey' => 'Antarktis / Casey',
    'Antarctica/Davis' => 'Antarktis / Davis',
    'Antarctica/DumontDUrville' => 'Antarktis / DumontDUrville',
    'Antarctica/Macquarie' => 'Antarktis / Macquarie',
    'Antarctica/McMurdo' => 'Antarktis / McMurdo',
    'Antarctica/Mawson' => 'Antarktis / Mawson',
    'Antarctica/Palmer' => 'Antarktis / Palmer',
    'Antarctica/Rothera' => 'Antarktis / Rothera',
    'Antarctica/Syowa' => 'Antarktis / Syowa',
    'Antarctica/Troll' => 'Antarktis / Troll',
    'Antarctica/Vostok' => 'Antarktis / Wostok',
    'Arctic/Longyearbyen' => 'Arktis / Longyearbyen',
    'Asia/Aden' => 'Asien / Aden',
    'Asia/Almaty' => 'Asien / Almaty',
    'Asia/Amman' => 'Asien / Amman',
    'Asia/Anadyr' => 'Asien / Anadyr',
    'Asia/Aqtau' => 'Asien / Aqtau',
    'Asia/Aqtobe' => 'Asien / Aqtobe',
    'Asia/Ashgabat' => 'Asien / Ashgabat',
    'Asia/Atyrau' => 'Asien / Atyrau',
    'Asia/Baghdad' => 'Asien / Bagdad',
    'Asia/Bahrain' => 'Asien / Bahrain',
    'Asia/Baku' => 'Asien / Baku',
    'Asia/Bangkok' => 'Asien / Bangkok',
    'Asia/Barnaul' => 'Asien / Barnaul',
    'Asia/Beirut' => 'Asien / Beirut',
    'Asia/Bishkek' => 'Asien / Bischkek',
    'Asia/Brunei' => 'Asien / Brunei',
    'Asia/Chita' => 'Asien / Chita',
    'Asia/Choibalsan' => 'Asien / Tschoibalsan',
    'Asia/Colombo' => 'Asien / Colombo',
    'Asia/Damascus' => 'Asien / Damaskus',
    'Asia/Dhaka' => 'Asien / Dhaka',
    'Asia/Dili' => 'Asien / Dili',
    'Asia/Dubai' => 'Asien / Dubai',
    'Asia/Dushanbe' => 'Asien / Duschanbe',
    'Asia/Famagusta' => 'Asien / Famagusta',
    'Asia/Gaza' => 'Asien / Gaza',
    'Asia/Hebron' => 'Asien / Hebron',
    'Asia/Ho_Chi_Minh' => 'Asien / Ho_Chi_Minh',
    'Asia/Hong_Kong' => 'Asien / Hong_Kong',
    'Asia/Hovd' => 'Asien / Hovd',
    'Asia/Irkutsk' => 'Asien / Irkutsk',
    'Asia/Jakarta' => 'Asien / Jakarta',
    'Asia/Jayapura' => 'Asien / Jayapura',
    'Asia/Jerusalem' => 'Asien / Jerusalem',
    'Asia/Kabul' => 'Asien / Kabul',
    'Asia/Kamchatka' => 'Asien / Kamtschatka',
    'Asia/Karachi' => 'Asien / Karachi',
    'Asia/Kathmandu' => 'Asien / Kathmandu',
    'Asia/Khandyga' => 'Asien / Khandyga',
    'Asia/Kolkata' => 'Asien / Kolkata',
    'Asia/Krasnoyarsk' => 'Asien / Krasnojarsk',
    'Asia/Kuala_Lumpur' => 'Asien / Kuala_Lumpur',
    'Asia/Kuching' => 'Asien / Kuching',
    'Asia/Kuwait' => 'Asien / Kuwait',
    'Asia/Macau' => 'Asien / Macau',
    'Asia/Magadan' => 'Asien / Magadan',
    'Asia/Makassar' => 'Asien / Makassar',
    'Asia/Manila' => 'Asien / Manila',
    'Asia/Muscat' => 'Asien / Muscat',
    'Asia/Nicosia' => 'Asien / Nikosia',
    'Asia/Novokuznetsk' => 'Asien / Novokuznetsk',
    'Asia/Novosibirsk' => 'Asien / Nowosibirsk',
    'Asia/Omsk' => 'Asien / Omsk',
    'Asia/Oral' => 'Asien / Oral',
    'Asia/Phnom_Penh' => 'Asien / Phnom_Penh',
    'Asia/Pontianak' => 'Asien / Pontianak',
    'Asia/Pyongyang' => 'Asien / Pjöngjang',
    'Asia/Qatar' => 'Asien / Katar',
    'Asia/Qostanay' => 'Asien / Qostanay',
    'Asia/Qyzylorda' => 'Asien / Qyzylorda',
    'Asia/Riyadh' => 'Asien / Riad',
    'Asia/Sakhalin' => 'Asien / Sachalin',
    'Asia/Samarkand' => 'Asien / Samarkand',
    'Asia/Seoul' => 'Asien / Seoul',
    'Asia/Shanghai' => 'Asien / Shanghai',
    'Asia/Singapore' => 'Asien / Singapur',
    'Asia/Srednekolymsk' => 'Asien / Srednekolymsk',
    'Asia/Taipei' => 'Asien / Taipei',
    'Asia/Tashkent' => 'Asien / Taschkent',
    'Asia/Tbilisi' => 'Asien / Tiflis',
    'Asia/Tehran' => 'Asien / Teheran',
    'Asia/Thimphu' => 'Asien / Thimphu',
    'Asia/Tokyo' => 'Asien / Tokio',
    'Asia/Tomsk' => 'Asien / Tomsk',
    'Asia/Ulaanbaatar' => 'Asien / Ulaanbaatar',
    'Asia/Urumqi' => 'Asien / Urumqi',
    'Asia/Ust-Nera' => 'Asien / Ust-Nera',
    'Asia/Vientiane' => 'Asien / Vientiane',
    'Asia/Vladivostok' => 'Asien / Wladiwostok',
    'Asia/Yakutsk' => 'Asien / Yakutsk',
    'Asia/Yangon' => 'Asien / Yangon',
    'Asia/Yekaterinburg' => 'Asien / Jekaterinburg',
    'Asia/Yerevan' => 'Asien / Eriwan',
    'Atlantic/Azores' => 'Atlantik / Azoren',
    'Atlantic/Bermuda' => 'Atlantik / Bermuda',
    'Atlantic/Canary' => 'Atlantik / Kanarische Inseln',
    'Atlantic/Cape_Verde' => 'Atlantic / Cape_Verde',
    'Atlantic/Faroe' => 'Atlantik / Färöer',
    'Atlantic/Madeira' => 'Atlantik / Madeira',
    'Atlantic/Reykjavik' => 'Atlantic / Reykjavik',
    'Atlantic/South_Georgia' => 'Atlantik / Südgeorgien',
    'Atlantic/St_Helena' => 'Atlantic / St_Helena',
    'Atlantic/Stanley' => 'Atlantic / Stanley',
    'Australia/Adelaide' => 'Australien / Adelaide',
    'Australia/Brisbane' => 'Australien / Brisbane',
    'Australia/Broken_Hill' => 'Australien / Broken_Hill',
    'Australia/Currie' => 'Australien / Currie',
    'Australia/Darwin' => 'Australien / Darwin',
    'Australia/Eucla' => 'Australien / Eucla',
    'Australia/Hobart' => 'Australien / Hobart',
    'Australia/Lindeman' => 'Australien / Lindeman',
    'Australia/Lord_Howe' => 'Australien / Lord_Howe',
    'Australia/Melbourne' => 'Australien / Melbourne',
    'Australia/Perth' => 'Australien / Perth',
    'Australia/Sydney' => 'Australien / Sydney',
    'Europe/Amsterdam' => 'Europa / Amsterdam',
    'Europe/Andorra' => 'Europa / Andorra',
    'Europe/Astrakhan' => 'Europa / Astrachan',
    'Europe/Athens' => 'Europa / Athen',
    'Europe/Belgrade' => 'Europa / Belgrad',
    'Europe/Berlin' => 'Europa / Berlin',
    'Europe/Bratislava' => 'Europa / Bratislava',
    'Europe/Brussels' => 'Europa / Brüssel',
    'Europe/Bucharest' => 'Europa / Bukarest',
    'Europe/Budapest' => 'Europa / Budapest',
    'Europe/Busingen' => 'Europa / Busingen',
    'Europe/Chisinau' => 'Europa / Chisinau',
    'Europe/Copenhagen' => 'Europa / Kopenhagen',
    'Europe/Dublin' => 'Europa / Dublin',
    'Europe/Gibraltar' => 'Europa / Gibraltar',
    'Europe/Guernsey' => 'Europa / Guernsey',
    'Europe/Helsinki' => 'Europa / Helsinki',
    'Europe/Isle_of_Man' => 'Europa / Isle_of_Man',
    'Europe/Istanbul' => 'Europa / Istanbul',
    'Europe/Jersey' => 'Europa / Jersey',
    'Europe/Kaliningrad' => 'Europa / Kaliningrad',
    'Europe/Kiev' => 'Europa / Kiew',
    'Europe/Kirov' => 'Europa / Kirov',
    'Europe/Lisbon' => 'Europa / Lissabon',
    'Europe/Ljubljana' => 'Europa / Ljubljana',
    'Europe/London' => 'Europa / London',
    'Europe/Luxembourg' => 'Europa / Luxemburg',
    'Europe/Madrid' => 'Europa / Madrid',
    'Europe/Malta' => 'Europa / Malta',
    'Europe/Mariehamn' => 'Europa / Mariehamn',
    'Europe/Minsk' => 'Europa / Minsk',
    'Europe/Monaco' => 'Europa / Monaco',
    'Europe/Moscow' => 'Europa / Moskau',
    'Europe/Oslo' => 'Europa / Oslo',
    'Europe/Paris' => 'Europa / Paris',
    'Europe/Podgorica' => 'Europa / Podgorica',
    'Europe/Prague' => 'Europa / Prag',
    'Europe/Riga' => 'Europa / Riga',
    'Europe/Rome' => 'Europa / Rom',
    'Europe/Samara' => 'Europa / Samara',
    'Europe/San_Marino' => 'Europa / San_Marino',
    'Europe/Sarajevo' => 'Europa / Sarajevo',
    'Europe/Saratov' => 'Europa / Saratov',
    'Europe/Simferopol' => 'Europa / Simferopol',
    'Europe/Skopje' => 'Europa / Skopje',
    'Europe/Sofia' => 'Europa / Sofia',
    'Europe/Stockholm' => 'Europa / Stockholm',
    'Europe/Tallinn' => 'Europa / Tallinn',
    'Europe/Tirane' => 'Europa / Tirane',
    'Europe/Ulyanovsk' => 'Europa / Uljanowsk',
    'Europe/Uzhgorod' => 'Europa / Uschgorod',
    'Europe/Vaduz' => 'Europa / Vaduz',
    'Europe/Vatican' => 'Europa / Vatikan',
    'Europe/Vienna' => 'Europa / Wien',
    'Europe/Vilnius' => 'Europa / Vilnius',
    'Europe/Volgograd' => 'Europa / Wolgograd',
    'Europe/Warsaw' => 'Europa / Warschau',
    'Europe/Zagreb' => 'Europa / Zagreb',
    'Europe/Zaporozhye' => 'Europa / Zaporozhye',
    'Europe/Zurich' => 'Europa / Zürich',
    'Indian/Antananarivo' => 'Indian / Antananarivo',
    'Indian/Chagos' => 'Indian / Chagos',
    'Indian/Christmas' => 'Indian / Weihnachtsinsel',
    'Indian/Cocos' => 'Indian / Cocos',
    'Indian/Comoro' => 'Indian / Comoro',
    'Indian/Kerguelen' => 'Indian / Kerguelen',
    'Indian/Mahe' => 'Indian / Mahe',
    'Indian/Maldives' => 'Indian / Malediven',
    'Indian/Mauritius' => 'Indian / Mauritius',
    'Indian/Mayotte' => 'Indian / Mayotte',
    'Indian/Reunion' => 'Indian / Wiedersehen',
    'Pacific/Apia' => 'Pazifik / Apia',
    'Pacific/Auckland' => 'Pazifik / Auckland',
    'Pacific/Bougainville' => 'Pazifik / Bougainville',
    'Pacific/Chatham' => 'Pazifik / Chatham',
    'Pacific/Chuuk' => 'Pazifik / Chuuk',
    'Pacific/Easter' => 'Pazifik / Osterinsel',
    'Pacific/Efate' => 'Pazifik / Efate',
    'Pacific/Enderbury' => 'Pazifik / Enderbury',
    'Pacific/Fakaofo' => 'Pazifik / Fakaofo',
    'Pacific/Fiji' => 'Pazifik / Fidschi',
    'Pacific/Funafuti' => 'Pazifik / Funafuti',
    'Pacific/Galapagos' => 'Pazifik / Galapagos',
    'Pacific/Gambier' => 'Pazifik / Gambier',
    'Pacific/Guadalcanal' => 'Pazifik / Guadalcanal',
    'Pacific/Guam' => 'Pazifik / Guam',
    'Pacific/Honolulu' => 'Pazifik / Honolulu',
    'Pacific/Kiritimati' => 'Pazifik / Kiritimati',
    'Pacific/Kosrae' => 'Pazifik / Kosrae',
    'Pacific/Kwajalein' => 'Pazifik / Kwajalein',
    'Pacific/Majuro' => 'Pazifik / Majuro',
    'Pacific/Marquesas' => 'Pazifik / Marquesas',
    'Pacific/Midway' => 'Pazifik / Auf halbem Weg',
    'Pacific/Nauru' => 'Pazifik / Nauru',
    'Pacific/Niue' => 'Pazifik / Niue',
    'Pacific/Norfolk' => 'Pazifik / Norfolk',
    'Pacific/Noumea' => 'Pazifik / Noumea',
    'Pacific/Pago_Pago' => 'Pazifik / Pago_Pago',
    'Pacific/Palau' => 'Pazifik / Palau',
    'Pacific/Pitcairn' => 'Pazifik / Pitcairn',
    'Pacific/Pohnpei' => 'Pazifik / Pohnpei',
    'Pacific/Port_Moresby' => 'Pazifik / Port_Moresby',
    'Pacific/Rarotonga' => 'Pazifik / Rarotonga',
    'Pacific/Saipan' => 'Pazifik / Saipan',
    'Pacific/Tahiti' => 'Pazifik / Tahiti',
    'Pacific/Tarawa' => 'Pazifik / Tarawa',
    'Pacific/Tongatapu' => 'Pazifik / Tongatapu',
    'Pacific/Wake' => 'Pazifik / Wake',
    'Pacific/Wallis' => 'Pazifik / Wallis',
    'UTC' => 'koordinierte Weltzeit',
    'Time Format' => 'Zeitformat',
    'Choose your default timezone' => 'Wählen Sie Ihre Standard-Zeitzone',
    'Signature' => 'Unterschrift',
    'User signature will be append at the bottom of ticket reply box' => 'Die Unterschrift des Benutzers wird am unteren Rand des Antwortfelds des Tickets angehängt.',
    'Password' => 'Passwort',
    'Password will remain same if you are not entering something in this field' => 'Das Passwort bleibt gleich, wenn Sie in dieses Feld nichts eingeben.',
    'Confirm Password' => 'Passwort bestätigen',
    'Password must contain minimum 8 character length, at least two letters (not case sensitive), one number, one special character(space is not allowed).' => 'Das Passwort muss mindestens 8 Zeichen lang sein, mindestens zwei Buchstaben (ohne Berücksichtigung der Groß- und Kleinschreibung), eine Zahl und ein Sonderzeichen (Leerzeichen sind nicht zulässig).',
    'Save Changes' => 'Änderungen speichern',
    'SAVE CHANGES' => 'ÄNDERUNGEN SPEICHERN',
    'CREATE TICKET' => 'TICKET ERSTELLEN',
    'Customer full name' => 'Vollständiger Name des Kunden',
    'Customer email address' => 'E-Mail-Adresse des Kunden',
    'Select Type' => 'Typ auswählen',
    'Support' => 'Support',
    'Choose ticket type' => 'Ticket-Typ wählen',
    'Ticket subject' => 'Ticket-Betreff',
    'Message' => 'Nachricht',
    'Query Message' => 'Nachricht abfragen',
    'Add Attachment' => 'Anhang hinzufügen',
    'This field is mandatory' => 'Das Feld ist obligatorisch',
    'General' => 'Allgemeines',
    'Designation' => 'Bezeichnung',
    'Contant Number' => 'Contant Number',
    'User signature will be append in the bottom of ticket reply box' => 'Die Unterschrift des Benutzers wird unten im Antwortfeld des Tickets angehängt.',
    'Account Status' => 'Kontostatus',
    'Account is Active' => 'Konto ist aktiv',
    'Assigning group(s) to user to view tickets regardless assignment.' => 'Zuweisen von Gruppen zu Benutzern, um Tickets unabhängig von der Zuweisung anzuzeigen.',
    'Default' => 'Standard',
    'Select All' => 'Wählen Sie Alle',
    'Remove All' => 'Alles entfernen',
    'Assigning team(s) to user to view tickets regardless assignment.' => 'Zuweisen von Teams zu Benutzern, um Tickets unabhängig von der Zuweisung anzuzeigen.',
    'No Team added !' => 'Kein Team hinzugefügt!',
    'Permission' => 'Genehmigung',
    'Role' => 'Rolle',
    'Administrator' => 'Administrator',
    'Select agent role' => 'Agentenrolle auswählen',
    'Add Customer' => 'Kunden hinzufügen',
    'Action' => 'Aktion',
    'Account Owner' => 'Kontoinhaber',
    'Active' => 'Aktiv',
    'Edit' => 'Bearbeiten',
    'Delete' => 'Löschen',
    'Disabled' => 'Deaktiviert',
    'New Group' => 'Neue Gruppe',
    'Default Privileges' => 'Standardprivilegien',
    'New Privileges' => 'Neue Privilegien',
    'NEW PRIVILEGE' => 'NEUES PRIVILEGE',
    'New Privilege' => 'Neues Privileg',
    'New Team' => 'Neues Team',
    'No Record Found' => 'Kein Eintrag gefunden',
    'Order Synchronization' => 'Bestellungssynchronisation',
    'Easily integrate different ecommerce platforms with your helpdesk which can then be later used to swiftly integrate ecommerce order details with your support tickets.' => 'Integrieren Sie problemlos verschiedene E-Commerce-Plattformen in Ihren Helpdesk. Diese können später verwendet werden, um E-Commerce-Bestelldetails schnell in Ihre Support-Tickets zu integrieren.',
    'BigCommerce' => 'BigCommerce',
    'No channels have been added.' => 'Es wurden keine Kanäle hinzugefügt.',
    'Add BigCommerce Store' => 'BigCommerce Store hinzufügen',
    'ADD BIGCOMMERCE STORE' => 'ADD BIGCOMMERCE STORE',
    'Mangento' => 'Mangento',
    'Add Magento Store' => 'Magento Store hinzufügen',
    'OpenCart' => 'OpenCart',
    'Add OpenCart Store' => 'OpenCart Store hinzufügen',
    'ADD OPENCART STORE' => 'OPENCART STORE HINZUFÜGEN',
    'Shopify' => 'Shopify',
    'Add Shopify Store' => 'Shopify Store hinzufügen',
    'ADD SHOPIFY STORE' => 'SHOPIFY STORE HINZUFÜGEN',
    'Integrate a new BigCommerce store' => 'Integriere einen neuen BigCommerce Store',
    'Your BigCommerce Store Name' => 'Ihr BigCommerce Store Name',
    'Your BigCommerce Store Hash' => 'Ihr BigCommerce Store Hash',
    'Your BigCommerce Api Token' => 'Ihr BigCommerce-API-Token',
    'Your BigCommerce Api Client ID' => 'Ihre BigCommerce-API-Kunden-ID',
    'Enable Channel' => 'Kanal aktivieren',
    'Add Store' => 'Store hinzufügen',
    'ADD STORE' => 'STORE HINZUFÜGEN',
    'Integrate a new Magento store' => 'Integriere einen neuen Magento Store',
    'Your Magento Api Username' => 'Dein Magento Api Benutzername',
    'Your Magento Api Password' => 'Dein Magento-API-Passwort',
    'Integrate a new OpenCart store' => 'Integriere einen neuen OpenCart Store',
    'Your OpenCart Api Key' => 'Ihr OpenCart-API-Schlüssel',
    'Your Shopify Store Name' => 'Ihr Shopify-Filialname',
    'Your Shopify Api Key' => 'Ihr Shopify-API-Schlüssel',
    'Your Shopify Api Password' => 'Ihr Shopify-API-Passwort',
    'Easily embed custom form to help generate helpdesk tickets.' => 'Einfaches Einbetten eines benutzerdefinierten Formulars zur Erstellung von Helpdesk-Tickets.',
    'Form-Builder' => 'Formular-Generator',
    'Add Formbuilder' => 'Formbuilder hinzufügen',
    'ADD FORMBUILDER' => 'FORMBUILDER HINZUFÜGEN',
    'No FormBuilder have been added.' => 'Es wurde kein FormBuilder hinzugefügt.',
    'Create a New Custom Form Below' => 'Erstellen Sie unten ein neues benutzerdefiniertes Formular',
    'Form Name' => 'Formularname',
    'It will be shown in the list of created forms' => 'Es wird in der Liste der erstellten Formulare angezeigt.',
    'MANDATORY FIELDS' => 'PFLICHTFELDER',
    'These fields will be visible in form and cant be edited' => 'Diese Felder werden im Formular angezeigt und können nicht bearbeitet werden',
    'Reply' => 'Antworten',
    'OPTIONAL FIELDS' => 'OPTIONALE FELDER',
    'Select These Fields to Add in your Form' => 'Wählen Sie diese Felder aus, um sie in Ihr Formular einzufügen',
    'GDPR' => 'GDPR',
    'Order' => 'Bestellung',
    'Categorybuilder' => 'Categorybuilder',
    'File' => 'Datei',
    'Add Form' => 'Formular hinzufügen',
    'ADD FORM' => 'FORMULAR HINZUFÜGEN',
    'UPDATE FORM' => 'UPDATE FORMULAR',
    'Update Form' => 'Formular aktualisieren',
    'Embed' => 'Einbetten',
    'EMBED' => 'EINBETTEN',
    'EMBED FORMBUILDER' => 'EMBED FORMBUILDER',
    'Embed Formbuilder' => 'Formbuilder einbetten',
    'Visit' => 'Besuch',
    'VISIT' => 'BESUCH',
    'Code' => 'Code',
    'Total Ticket(s)' => 'Ticket (s) insgesamt',
    'Ticket Count' => 'Ticketanzahl',
    'SwiftMailer Configurations' => 'SwiftMailer-Konfigurationen',
    'No swiftmailer configurations found' => 'Keine Swiftmailer-Konfigurationen gefunden',
    'CREATE CONFIGURATION' => 'KONFIGURATION ERSTELLEN',
    'Add configuration' => 'Konfiguration hinzufügen',
    'Update configuration' => 'Konfiguration aktualisieren',
    'Mailer ID' => 'Mailer ID',
    'Mailer ID - Leave blank to automatically create id' => 'Mailer ID - Leer lassen, um automatisch eine ID zu erstellen',
    'Transport Type' => 'Transportart',
    'SMTP' => 'SMTP',
    'Enable Delivery' => 'Zustellung aktivieren',
    'Server' => 'Server',
    'Port' => 'Port',
    'Encryption Mode' => 'Verschlüsselungsmodus',
    'ssl' => 'ssl',
    'tsl' => 'tsl',
    'None' => 'Keiner',
    'Authentication Mode' => 'Authentifizierungsmodus',
    'login' => 'Anmeldung',
    'Plain' => 'Einfach',
    'CRAM-MD5' => 'CRAM-MD5',
    'Sender Address' => 'Absenderadresse',
    'Delivery Address' => 'Lieferadresse',
    'Block Spam' => 'Spam blockieren',
    'Black list' => 'Schwarze Liste',
    'Comma (,) separated values (Eg. support@example.com, @example.com, 68.98.31.226)' => 'Durch Komma (,) getrennte Werte (z. B. support@example.com, @ example.com, 68.98.31.226)',
    'White list' => 'Weiße Liste',
    'Mailbox Settings' => 'Mailbox-Einstellungen',
    'No mailbox configurations found' => 'Keine Mailbox-Konfigurationen gefunden',
    'NEW MAILBOX' => 'NEUE MAILBOX',
    'New Mailbox' => 'NEUE MAILBOX',
    'Update Mailbox' => 'Mailbox aktualisieren',
    'Add Mailbox' => 'Mailbox hinzufügen',
    'Mailbox ID - Leave blank to automatically create id' => 'Mailbox ID - Leer lassen, um automatisch eine ID zu erstellen',
    'Mailbox Name' => 'Postfachname',
    'Enable Mailbox' => 'Mailbox aktivieren',
    'Incoming Mail (IMAP) Server' => 'Posteingangsserver (IMAP)',
    'Configure your imap settings which will be used to fetch emails from your mailbox.' => 'Konfigurieren Sie Ihre IMAP-Einstellungen, die zum Abrufen von E-Mails aus Ihrer Mailbox verwendet werden.',
    'Transport' => 'Transport',
    'IMAP' => 'IMAP',
    'Gmail' => 'Google Mail',
    'Yahoo' => 'Yahoo',
    'Host' => 'Wirt',
    'IMAP Host' => 'IMAP-Host',
    'Email address' => 'E-Mail-Addresse',
    'Associated Password' => 'Zugehöriges Passwort',
    'Outgoing Mail (SMTP) Server' => 'Postausgangsserver (SMTP)',
    'Select a valid Swift Mailer configuration which will be used to send emails through your mailbox.' => 'Wählen Sie eine gültige Swift Mailer-Konfiguration aus, mit der E-Mails über Ihre Mailbox gesendet werden.',
    'Swift Mailer ID' => 'Swift Mailer ID',
    'None Selected' => 'Nichts ausgewählt',
    'Create Mailbox' => 'Mailbox erstellen',
    'CREATE MAILBOX' => 'MAILBOX ERSTELLEN',
    'New Template' => 'Neue Vorlage',
    'NEW TEMPLATE' => 'NEUE VORLAGE',
    'Customer Forgot Password' => 'Kunde hat Passwort vergessen',
    'Customer Account Created' => 'Kundenkonto erstellt',
    'Ticket generated success mail to customer' => 'Ticket generierte Erfolgsmail an Kunden',
    'Customer Reply To The Agent' => 'Kundenantwort an den Agenten',
    'Ticket Assign' => 'Ticket zuweisen',
    'Agent Forgot Password' => 'Agent Passwort vergessen',
    'Agent Account Created' => 'Agentenkonto erstellt',
    'Ticket generated by customer' => 'Ticket vom Kunden generiert',
    'Agent Reply To The Customers ticket' => 'Agentenantwort auf das Ticket des Kunden',
    'Email template name' => 'Name der E-Mail-Vorlage',
    'Email template subject' => 'Betreff der E-Mail-Vorlage',
    'Template For' => 'Vorlage für',
    'Nothing Selected' => 'Nichts ausgewählt',
    'email template will be used for work related with selected option' => 'Die E-Mail-Vorlage wird für die Arbeit mit der ausgewählten Option verwendet.',
    'Email template body' => 'E-Mail-Vorlagenkörper',
    'Body' => 'Körper',
    'placeholders' => 'Platzhalter',
    'Ticket Subject' => 'Ticket Betreff',
    'Ticket Message' => 'Ticket Nachricht',
    'Ticket Attachments' => 'Ticket-Anhänge',
    'Ticket Tags' => 'Ticket-Tags',
    'Ticket Source' => 'Ticketquelle',
    'Ticket Status' => 'Ticket Status',
    'Ticket Priority' => 'Ticket Priorität',
    'Ticket Group' => 'Ticketgruppe',
    'Ticket Team' => 'Ticket-Team',
    'Ticket Thread Message' => 'Ticket Thread Nachricht',
    'Ticket Customer Name' => 'Ticket-Kundenname',
    'Ticket Customer Email' => 'Ticket-Kunden-E-Mail',
    'Ticket Agent Name' => 'Ticket Agent Name',
    'Ticket Agent Email' => 'Ticket Agent Email',
    'Ticket Agent Link' => 'Ticket Agent Link',
    'Ticket Customer Link' => 'Ticket-Kunden-Link',
    'Last Collaborator Name' => 'Name des letzten Mitarbeiters',
    'Last Collaborator Email' => 'Letzte Mitarbeiter-E-Mail',
    'Agent/ Customer Name' => 'Agent / Kunde',
    'Account Validation Link' => 'Link zur Kontoüberprüfung',
    'Password Forgot Link' => 'Passwort vergessener Link',
    'Company Name' => 'Name der Firma',
    'Company Logo' => 'Firmenlogo',
    'Company URL' => 'Firmen-URL',
    'Swiftmailer id (Select from drop down)' => 'Swiftmailer-ID (Auswahl aus Dropdown-Liste)',
    'PROCEED' => 'VORGEHEN',
    'Proceed' => 'Vorgehen',
    'Theme Color' => 'Themenfarbe',
    'Customer Created' => 'Kunde erstellt',
    'Agent Created' => 'Agent erstellt',
    'Ticket Created' => 'Ticket erstellt',
    'Agent Replied on Ticket' => 'Agent hat auf Ticket geantwortet',
    'Customer Replied on Ticket' => 'Kunde hat auf Ticket geantwortet',
    'Workflow Status' => 'Workflow Status',
    'Workflow is Active' => 'Workflow ist aktiv',
    'Events' => 'Veranstaltungen',
    'An event automatically triggers to check conditions and perform a respective pre-defined set of actions' => 'Ein Ereignis wird automatisch ausgelöst, um die Bedingungen zu überprüfen und einen entsprechenden vordefinierten Satz von Aktionen auszuführen.',
    'Select an Event' => 'Event auswählen',
    'Add More' => 'Weitere hinzufügen',
    'Conditions' => 'Bedingungen',
    'Conditions are set of rules which checks for specific scenarios and are triggered on specific occasions' => 'Bedingungen sind Regeln, die nach bestimmten Szenarien suchen und bei bestimmten Gelegenheiten ausgelöst werden.',
    'Subject or Description' => 'Betreff oder Beschreibung',
    'Actions' => 'Aktionen',
    'An action not only reduces the workload but also makes it quite easier for ticket automation' => 'Eine Aktion reduziert nicht nur den Arbeitsaufwand, sondern erleichtert auch die Ticketautomatisierung erheblich.',
    'Select an Action' => 'Aktion auswählen',
    'Add Note' => 'Notiz hinzufügen',
    'Mail to agent' => 'Mail to agent',
    'Mail to customer' => 'Mail an kunden',
    'Mail to group' => 'Mail an Gruppe',
    'Mail to last collaborator' => 'Mail an letzten Mitarbeiter',
    'Mail to team' => 'Mail an das Team',
    'Mark Spam' => 'Spam markieren',
    'Assign to agent' => 'Agent zuweisen',
    'Assign to group' => 'Zu Gruppe zuordnen',
    'Set Priority As' => 'Priorität festlegen als',
    'Set Status As' => 'Status setzen als',
    'Set Tag As' => 'Tag setzen als',
    'Set Label As' => 'Label festlegen als',
    'Assign to team' => 'Zu Team zuordnen',
    'Set Type As' => 'Typ festlegen als',
    'Add Workflow' => 'Workflow hinzufügen',
    'ADD WORKFLOW' => 'WORKFLOW HINZUFÜGEN',
    'Ticket Type code' => 'Ticket Type Code',
    'Ticket Type description' => 'Ticket Typ Beschreibung',
    'Type Status' => 'Typstatus',
    'Type is Active' => 'Typ ist aktiv',
    'Add Save Reply' => 'Hinzufügen Speichern Antwortnen',
    'Saved reply name' => 'Name der gespeicherten Antwort',
    'Share saved reply with user(s) in these group(s)' => 'Gespeicherte Antwort mit Benutzern in diesen Gruppen teilen',
    'Share saved reply with user(s) in these teams(s)' => 'Gespeicherte Antwort mit Benutzern in diesen Teams teilen',
    'Saved reply Body' => 'Gespeicherter Antworttext',
    'New Prepared Response' => 'Neue vorbereitete Antwort',
    'Prepared Response Status' => 'Status der vorbereiteten Antwort',
    'Prepared Response is Active' => 'Vorbereitete Antwort ist aktiv',
    'Share prepared response with user(s) in these group(s)' => 'Teilen Sie vorbereitete Antworten mit Benutzern in diesen Gruppen',
    'Share prepared response with user(s) in these teams(s)' => 'Teilen Sie vorbereitete Antworten mit Benutzern in diesen Teams.',
    'ADD PREPARED RESPONSE' => 'VORBEREITETE ANTWORT HINZUFÜGEN',
    'Add Prepared Response' => 'Vorbereitete Antwort hinzufügen',
    'Folder Name is shown upfront at Knowledge Base' => 'Ordnername wird in der Wissensbasis vorne angezeigt',
    'A small text about the folder helps user to navigate more easily' => 'Ein kleiner Text über den Ordner erleichtert dem Benutzer das Navigieren.',
    'Publish' => 'Veröffentlichen',
    'Choose appropriate status' => 'Wählen Sie den entsprechenden Status',
    'Folder Image' => 'Ordnerbild',
    'An image is worth a thousands words and makes folder more accessible' => 'Ein Bild sagt mehr als tausend Worte und macht Ordner zugänglicher',
    'Add Category' => 'Kategorie hinzufügen',
    'Category Name is shown upfront at Knowledge Base' => 'Der Kategoriename wird in der Wissensbasis vorne angezeigt.',
    'A small text about the category helps user to navigate more easily' => 'Ein kleiner Text über die Kategorie erleichtert dem Benutzer das Navigieren.',
    'Using Category Order, you can decide which category should display first' => 'Mit der Kategoriereihenfolge können Sie entscheiden, welche Kategorie zuerst angezeigt werden soll.',
    'Sorting' => 'Sortierung',
    'Ascending Order (A-Z)' => 'Aufsteigende Reihenfolge (A-Z)',
    'Descending Order (Z-A)' => 'Absteigende Reihenfolge (Z-A)',
    'Based on Popularity' => 'Basierend auf Popularität',
    'Article of this category will display according to selected option' => 'Artikel dieser Kategorie werden nach ausgewählter Option angezeigt',
    'Article' => 'Artikel',
    'Title' => 'Titel',
    'View' => 'Aussicht',
    'Make as Starred' => 'Machen Sie wie markiert',
    'Yes' => 'Ja',
    'No' => 'Nein',
    'Stared' => 'Starrte',
    'Revisions' => 'Überarbeitungen',
    'Related Articles' => 'In Verbindung stehende Artikel',
    'Delete Article' => 'Artikel löschen',
    'Content' => 'Inhalt',
    'Slug' => 'Schnecke',
    'Slug is the url identity of this article.' => 'Slug ist die URL-Identität dieses Artikels.',
    'Meta Title' => 'Meta-Titel',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'Titel-Tags und Meta-Beschreibungen sind Teile des HTML-Codes im Header einer Webseite. Sie helfen Suchmaschinen, den Inhalt einer Seite zu verstehen. Das Titel-Tag und die Meta-Beschreibung einer Seite werden normalerweise angezeigt, wenn diese Seite in Suchmaschinenergebnissen angezeigt wird.',
    'Meta Keywords' => 'Meta-Keywords',
    'Meta Description' => 'Meta Description',
    'Description' => 'Beschreibung',
    'Team Status' => 'Team Status',
    'Team is Active' => 'Team ist aktiv',
    'Edit Privilege' => 'Berechtigung bearbeiten',
    'Can create ticket' => 'Kann Ticket erstellen',
    'Can edit ticket' => 'Kann Ticket bearbeiten',
    'Can delete ticket' => 'Kann Ticket löschen',
    'Can restore trashed ticket' => 'Kann das Ticket im Papierkorb wiederherstellen',
    'Can assign ticket' => 'Kann Ticket zuweisen',
    'Can assign ticket group' => 'Kann Ticketgruppe zuordnen',
    'Can update ticket status' => 'Kann Ticketstatus aktualisieren',
    'Can update ticket priority' => 'Kann Ticketpriorität aktualisieren',
    'Can update ticket type' => 'Kann Ticket-Typ aktualisieren',
    'Can add internal notes to ticket' => 'Kann interne Notizen zum Ticket hinzufügen',
    'Can edit thread/notes' => 'Kann Thread / Notizen bearbeiten',
    'Can lock/unlock thread' => 'Kann Thread sperren / entsperren',
    'Can add collaborator to ticket' => 'Kann Mitbearbeiter zum Ticket hinzufügen',
    'Can delete collaborator from ticket' => 'Kann Mitbearbeiter aus Ticket löschen',
    'Can delete thread/notes' => 'Kann Thread / Notizen löschen',
    'Can apply prepared response on ticket' => 'Kann vorbereitete Antwort auf Ticket anwenden',
    'Can add ticket tags' => 'Kann Ticket-Tags hinzufügen',
    'Can delete ticket tags' => 'Kann Ticket-Tags löschen',
    'Can kick other ticket users' => 'Kann andere Ticketbenutzer kicken',
    'Can manage email templates' => 'Kann E-Mail-Vorlagen verwalten',
    'Can manage groups' => 'Kann Gruppen verwalten',
    'Can manage Sub-Groups/ Teams' => 'Kann Untergruppen / Teams verwalten',
    'Can manage agents' => 'Kann Agenten verwalten',
    'Can manage agent privileges' => 'Kann Agentenrechte verwalten',
    'Can manage ticket types' => 'Kann Ticket-Typen verwalten',
    'Can manage ticket custom fields' => 'Kann benutzerdefinierte Ticketfelder verwalten',
    'Can manage customers' => 'Kann Kunden verwalten',
    'Can manage Prepared Responses' => 'Kann vorbereitete Antworten verwalten',
    'Can manage Automatic workflow' => 'Kann den automatischen Workflow verwalten',
    'Can manage tags' => 'Kann Tags verwalten',
    'Can manage knowledgebase' => 'Kann Wissensbasis verwalten',
    'Can manage Groups Saved Reply' => 'Kann gespeicherte Antworten der Gruppe verwalten',
    'Add Privilege' => 'Privileg hinzufügen',
    'Choose set of privileges which will be available to the agent.' => 'Wählen Sie eine Reihe von Berechtigungen aus, die dem Agenten zur Verfügung stehen.',
    'Advanced' => 'Erweitert',
    'Privilege Name must have characters only' => 'Berechtigungsname darf nur Zeichen enthalten',
    'Maximum character length is 50' => 'Maximale Zeichenlänge beträgt 50',
    'Open Tickets' => 'Offene Tickets',
    'New Customer' => 'Neukunde',
    'New Agent' => 'Neuer Agent',
    'Total Article(s)' => 'Artikel insgesamt',
    'Please specify a valid email address' => 'Bitte geben Sie eine gültige E-Mail-Adresse an.',
    'Please enter the password associated with your email address' => 'Bitte geben Sie das mit Ihrer E-Mail-Adresse verknüpfte Passwort ein.',
    'Please enter your server host address' => 'Bitte geben Sie Ihre Server-Host-Adresse ein',
    'Please specify a port number to connect with your mail server' => 'Bitte geben Sie eine Portnummer an, um sich mit Ihrem Mailserver zu verbinden',
    'Success ! Branding details saved successfully.' => 'Erfolg! Markenbildung erfolgreich gespeichert.',
    'Success ! Time details saved successfully.' => 'Erfolg! Zeitangaben erfolgreich gespeichert.',
    'Spam setting saved successfully.' => 'Spam-Einstellung erfolgreich gespeichert.',
    'Please specify a valid name for your mailbox.' => 'Einen gültigen Namen für Mailbox angeben.',
    'Please select a valid swift-mailer configuration.' => 'Eine gültige E-Mail-Konfiguration wählen.',
    'Please specify a valid host address.' => 'Bitte geben Sie eine gültige Hostadresse an.',
    'Please specify a valid email address.' => 'Bitte geben Sie eine gültige E-Mail-Adresse an.',
    'Please enter the associated account password.' => 'Bitte geben Sie das zugehörige Passwort ein.',
    'New Saved Reply' => 'Neue gespeicherte Antwort',
    'New Category' => 'Neue Kategorie',
    'Folder' => 'Mappe',
    'Category' => 'Kategorie',
    'Created' => 'Erstellt',
    'All Articles' => 'Alle Artikel',
    'Viewed' => 'Gesehen',
    'New Article' => 'Neuer Artikel',
    'Thank you for your feedback!' => 'Danke für Ihre Rückmeldung!',
    'Was this article helpful?' => 'War dieser Artikel hilfreich?',
    'Helpdesk' => 'Helpdesk',
    'Support Center' => 'Supportzentrum',
    'Mailboxes' => 'Postfächer',
    'By' => 'Durch',
    'Search Tickets' => 'Tickets suchen',
    'Customer Information' => 'Kunde',
    'Total Replies' => 'Anzahl Antworten',
    'Filter With' => 'Filtern mit',
    'Type email to add' => 'E-Mail zum Hinzufügen eingeben',
    'Collaborators' => 'Mitarbeiter',
    'Labels' => 'Etiketten',
    'Group' => 'Gruppe',
    'group' => 'Gruppe',
    'Contact Team' => 'Team kontaktieren',
    'Stay on ticket' => 'Bleiben Sie auf Ticket',
    'Redirect to list' => 'Zur Liste umleiten',
    'Nothing interesting here...' => 'Noch nichts zu sehen...',
    'Previous Ticket' => 'Vorheriges Ticket',
    'Next Ticket' => 'Nächstes Ticket',
    'Forward' => 'Weiterleiten',
    'Note' => 'Hinweis',
    'Write a reply' => 'Eine Antwort schreiben',
    'Created Ticket' => 'Erstelltes Ticket',
    'All Threads' => 'Alle Themen',
    'Forwards' => 'Weiterleitungen',
    'Notes' => 'Anmerkungen',
    'Pinned' => 'Gemerkt',
    'Edit Ticket' => 'Ticket bearbeiten',
    'Print Ticket' => 'Ticket drucken',
    'Mark as Spam' => 'Als Spam markieren',
    'Mark as Closed' => 'Als geschlossen markieren',
    'Delete Ticket' => 'Ticket löschen',
    'View order details from different eCommerce channels' => 'Bestelldetails aus verschiedenen E-Commerce-Kanälen anzeigen',
    'ECOMMERCE CHANNELS' => 'ECOMMERCE-KANÄLE',
    'Select channel' => 'Kanal auswählen',
    'Order Id' => 'Auftragsnummer',
    'Fetch Order' => 'Bestellung abrufen',
    'No orders have been integrated to this ticket yet.' => 'Zu diesem Ticket wurden noch keine Bestellungen integriert.',
    'Enter your credentials below to gain access to your helpdesk account.' => 'Geben Sie unten Ihre Anmeldeinformationen ein, um Zugriff auf Ihr Helpdesk-Konto zu erhalten.',
    'Keep me logged in' => 'Angemeldet bleiben',
    'Forgot Password?' => 'Passwort vergessen?',
    'Log in to your' => 'Melden Sie sich bei Ihrem an.',
    'Sign In' => 'Anmelden',
    'Edit Customer' => 'Kunden bearbeiten',
    'Update' => 'Aktualisieren',
    'Discard' => 'Verwerfen',
    'Cancel' => 'Stornieren',
    'Not Assigned' => 'Nicht zugeordnet',
    'Submit' => 'Senden',
    'Submit And Open' => 'Senden und Status \'offen\'',
    'Submit And Pending' => 'Senden und Status \'in Bearbeitung\'',
    'Submit And Answered' => 'Senden und Status \'beantwortet\'',
    'Submit And Resolved' => 'Senden und Status \'gelöst\'',
    'Submit And Closed' => 'Senden und Status \'geschlossen\'',
    'Choose a Color' => 'Farbe wählen',
    'Create' => 'Erstellen',
    'Edit Label' => 'Label bearbeiten',
    'Add Label' => 'Label hinzufügen',
    'To' => 'Bis',
    'Ticket' => 'Ticket',
    'Your browser does not support JavaScript or You disabled JavaScript, Please enable those !' => 'Ihr Browser unterstützt kein JavaScript oder Sie haben JavaScript deaktiviert, bitte aktivieren Sie diese!',
    'Confirm Action' => 'Aktion bestätigen',
    'Confirm' => 'Bestätigen',
    'No result found' => 'Keine Einträge gefunden',
    'ticket delivery status' => 'Ticket Lieferstatus',
    'Warning! Select valid image file.' => 'Warnung! Wählen Sie eine gültige Bilddatei.',
    'Error' => 'Fehler',
    'Save' => 'Speichern',
    'SEO' => 'SEO',
    'Edit Saved Filter' => 'Gespeicherten Filter bearbeiten',
    'Type atleast 2 letters' => 'Geben Sie mindestens 2 Buchstaben ein',
    'Remove Label' => 'Label entfernen',
    'New Saved Filter' => 'Neuer gespeicherter Filter',
    'Is Default' => 'Ist Standard',
    'Remove Saved Filter' => 'Gespeicherten Filter entfernen',
    'Ticket Info' => 'Ticket Info',
    'Last Replied Agent' => 'Letzter geantworteter Agent',
    'created Ticket' => 'Ticket erstellt',
    'Uploaded Files' => 'Hochgeladene Dateien',
    'Download (as .zip)' => 'Herunterladen (als ZIP-Datei)',
    'made last reply' => 'Letzte Antwort gemacht',
    'N/A' => 'N / A',
    'Unassigned' => 'Nicht zugewiesen',
    'Label' => 'Etikette',
    'Assigned to me' => 'Mir zugewiesen',
    'Search Query' => 'Suchanfrage',
    'Searching' => 'Suchen',
    'Saved Filter' => 'Gespeicherter Filter',
    'No Label Created' => 'Kein Label erstellt',
    'Label with same name already exist.' => 'Label mit gleichem Namen existiert bereits.',
    'Create New' => 'Neu',
    'Mail status' => 'Mail Status',
    'replied' => 'geantwortet',
    'added note' => 'Notiz hinzugefügt',
    'forwarded' => 'weitergeleitet',
    'TO' => 'AN',
    'CC' => 'CC',
    'BCC' => 'BCC',
    'Locked' => 'Verschlossen',
    'Edit Thread' => 'Thread bearbeiten',
    'Delete Thread' => 'Thread löschen',
    'Unpin Thread' => 'Thread abheften',
    'Pin Thread' => 'Thread anheften',
    'Unlock Thread' => 'Thread freischalten',
    'Lock Thread' => 'Thread sperren',
    'Translate Thread' => 'Thread übersetzen',
    'Language' => 'Sprache',
    'English' => 'Englisch',
    'French' => 'Französisch',
    'Italian' => 'Italienisch',
    'Arabic' => 'Arabisch',
    'German' => 'Deutsch',
    'Spanish' => 'Spanisch',
    'Turkish' => 'Türkisch',
    'Danish' => 'Dänisch',
    'Chinese' => 'CHINESISCH',
    'Polish' => 'POLIEREN',
    'System' => 'System',
    'Open in Files' => 'In Dateien öffnen',
    'Email address is invalid' => 'E-mail Adresse ist nicht korrekt',
    'Tag with same name already exist' => 'Tag mit gleichem Namen existiert bereits',
    'Text length should be less than 20 charactors' => 'Die Textlänge sollte weniger als 20 Zeichen betragen.',
    'Label with same name already exist' => 'Label mit gleichem Namen existiert bereits',
    'Agent Name' => 'Agent',
    'Agent Email' => 'Agent E-Mail',
    'open' => 'offen',
    'Currently active agents on ticket' => 'Derzeit aktive Agenten im Ticket',
    'Edit Customer Information' => 'Kundenangaben bearbeiten',
    'Restore' => 'Wiederherstellen',
    'Delete Forever' => 'Unwiederuflich löschen',
    'Add Team' => 'Team hinzufügen',
    'delete' => 'löschen',
    'You didnt have any folder for current filter(s).' => 'Msgstr Sie hatten keinen Ordner für aktuelle Filter.',
    'Add Folder' => 'Ordner hinzufügen',
    'This field must have valid characters only' => 'Dieses Feld darf nur gültige Zeichen enthalten',
    'Can edit task' => 'Kann Aufgabe bearbeiten',
    'Can create task' => 'Kann Aufgabe erstellen',
    'Can delete task' => 'Kann Aufgabe löschen',
    'Can add member to task' => 'Kann Mitglied zur Aufgabe hinzufügen',
    'Can remove member from task' => 'Kann Mitglied von Aufgabe entfernen',
    'Agent Privileges' => 'Agentenrechte',
    'Agent Privilege represents overall permissions in System.' => 'Die Agentenberechtigung repräsentiert die allgemeinen Berechtigungen im System.',
    'Ticket View' => 'Ticketansicht',
    'User can view tickets based on selected scope.' => 'Der Benutzer kann Tickets basierend auf dem ausgewählten Bereich anzeigen.',
    'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) he belongs to and so on' => 'Wenn der Benutzer über einen individuellen Zugriff verfügt, können nur zugewiesene Tickets angezeigt werden. Wenn der Teamzugriff verfügt, kann der Benutzer alle Tickets in Teams anzeigen, denen er angehört, usw.',
    'Global Access' => 'Globaler Zugriff',
    'Group Access' => 'Gruppenzugriff',
    'Team Access' => 'Teamzugang',
    'Individual Access' => 'Individueller Zugang',
    'This field must have characters only' => 'Dieses Feld darf nur Zeichen enthalten',
    'Maximum character length is 40' => 'Maximale Zeichenlänge beträgt 40',
    'This is not a valid email address' => 'Dies ist keine gültige e-mail Adresse',
    'Password must contains 8 Characters' => 'Passwort muss 8 Zeichen enthalten',
    'The passwords does not match' => 'Die Passwörter stimmen nicht überein',
    'Enabled' => 'Aktiviert',
    'Create Configuration' => 'Konfiguration erstellen',
    'Swift Mailer Settings' => 'Swift Mailer-Einstellungen',
    'Username' => 'Nutzername',
    'Please select a swiftmailer id' => 'Bitte wählen Sie eine swiftmailer ID',
    'Please enter a valid e-mail id' => 'Bitte geben Sie eine gültige E-Mail-ID ein',
    'Please enter a mailer id' => 'Bitte geben Sie eine Mailer-ID ein',
    'Email Id' => 'E-Mail-ID',
    'Are you sure? You want to perform this action.' => 'Sind Sie sicher? Sie möchten diese Aktion ausführen.',
    'Reorder' => 'Nachbestellen',
    'New Workflow' => 'Neuer Workflow',
    'OR' => 'ODER',
    'AND' => 'UND',
    'Please enter a valid name.' => 'Bitte geben Sie einen gültigen Namen ein.',
    'Please select a value.' => 'Bitte wählen Sie einen Wert aus.',
    'Please add a value.' => 'Bitte addieren Sie einen Wert.',
    'This field is required' => 'Dieses Feld wird benötigt',
    'or' => 'oder',
    'and' => 'und',
    'Select a Condition' => 'Wählen Sie eine Bedingung aus',
    'Loading...' => 'Wird geladen...',
    'Select Option' => 'Option wählen',
    'Inactive' => 'Inaktiv',
    'New Type' => 'Neuer Typ',
    'Placeholders' => 'Platzhalter',
    'Ticket Link' => 'Ticket Link',
    'Id' => 'Id',
    'Preview' => 'Vorschau',
    'Sort Order' => 'Sortierung',
    'This field must be a number' => 'Dieses Feld muss eine Zahl sein',
    'User' => 'Benutzer',
    'Edit Group' => 'Gruppe bearbeiten',
    'Group Status' => 'Gruppenstatus',
    'Group is Active' => 'Gruppe ist aktiv',
    'Add Group' => 'Gruppe hinzufügen',
    'Contact number is invalid' => 'Kontaktnummer ist ungültig',
    'Edit Agent' => 'Agent bearbeiten',
    'No Privilege added, Please add Privilege(s) first !' => 'Keine Berechtigungen hinzugefügt, bitte zuerst Berechtigungen hinzufügen!',
    'Edit Email Template' => 'E-Mail-Vorlage bearbeiten',
    'Edit Workflow' => 'Workflow bearbeiten',
    'Save Workflow' => 'Workflow speichern',
    'Edit Ticket Type' => 'Ticket-Typ bearbeiten',
    'Add Ticket Type' => 'Ticket-Typ hinzufügen',
    'Date Released' => 'Freigabedatum',
    'Free' => 'Kostenlos',
    'Premium' => 'Prämie',
    'Installed' => 'Eingerichtet',
    'Installed Applications' => 'Installierte Anwendungen',
    'Apps Dashboard' => 'Apps-Dashboard',
    'Dashboard' => 'Armaturenbrett',
    'Nothing Interesting here' => 'Nichts Interessantes hier',
    'No Categories Added' => 'Keine Kategorien hinzugefügt',
    'ticket' => 'Ticket',
    'Add Email Template' => 'E-Mail-Vorlage hinzufügen',
    'This field contain 100 characters only' => 'Dieses Feld enthält nur 100 Zeichen',
    'This field contain characters only' => 'Dieses Feld enthält nur Zeichen',
    'Name length must not be greater than 200 !!' => 'Die Länge des Namens darf 200 nicht überschreiten!',
    'Warning! Correct all field values first!' => 'Warnung! Korrigieren Sie zuerst alle Feldwerte!',
    'Warning ! This is not a valid request' => 'Warnung! Dies ist keine gültige Anfrage.',
    'Success ! Tag removed successfully.' => 'Erfolg! Tag erfolgreich entfernt. ',
    'Success ! Tags Saved successfully.' => 'Erfolg! Tags wurden erfolgreich gespeichert. ',
    'Success ! Revision restored successfully.' => 'Erfolg! Revision erfolgreich wiederhergestellt. ',
    'Success ! Categories updated successfully.' => 'Erfolg! Kategorien wurden erfolgreich aktualisiert. ',
    'Success ! Article Related removed successfully.' => 'Erfolg! Artikelverwandte erfolgreich entfernt. ',
    'Success ! Article Related is already added.' => 'Erfolg! Artikel ist bereits hinzugefügt. ',
    'Success ! Cannot add self as relative article.' => 'Erfolg! Ich kann mich nicht als relativen Artikel hinzufügen. ',
    'Success ! Article Related updated successfully.' => 'Erfolg! Artikelverwandt erfolgreich aktualisiert. ',
    'Success ! Articles removed successfully.' => 'Erfolg! Artikel erfolgreich entfernt. ',
    'Success ! Article status updated successfully.' => 'Erfolg! Artikelstatus erfolgreich aktualisiert. ',
    'Success ! Article star updated successfully.' => 'Erfolg! Artikelstern erfolgreich aktualisiert. ',
    'Success! Article updated successfully' => 'Erfolg! Artikel erfolgreich aktualisiert',
    'Success ! Category sort  order updated successfully.' => 'Erfolg! Sortierreihenfolge der Kategorie erfolgreich aktualisiert. ',
    'Success ! Category status updated successfully.' => 'Erfolg! Kategoriestatus erfolgreich aktualisiert. ',
    'Success ! Folders updated successfully.' => 'Erfolg! Ordner wurden erfolgreich aktualisiert. ',
    'Success ! Categories removed successfully.' => 'Erfolg! Kategorien wurden erfolgreich entfernt. ',
    'Success ! Category updated successfully.' => 'Erfolg! Kategorie erfolgreich aktualisiert. ',
    'Error ! Category is not exist.' => 'Fehler! Kategorie ist nicht vorhanden. ',
    'Warning ! Customer Login disabled by admin.' => 'Warnung! Kunden-Login vom Administrator deaktiviert. ',
    'This Email is not registered with us.' => 'Diese E-Mail ist bei uns nicht registriert.',
    'Your password has been updated successfully.' => 'Passwort wurde erfolgreich aktualisiert.',
    'Password dont match.' => 'Passwort stimmt nicht überein.',
    'Error ! Profile image is not valid, please upload a valid format' => 'Fehler! Profilbild ist ungültig. Bitte laden Sie ein gültiges Format hoch. ',
    'Success! Folder has been added successfully.' => 'Erfolg! Ordner wurde erfolgreich hinzugefügt. ',
    'Folder updated successfully.' => 'Ordner erfolgreich aktualisiert.',
    'Success ! Folder status updated successfully.' => 'Erfolg! Ordnerstatus erfolgreich aktualisiert. ',
    'Error ! Folder is not exist.' => 'Fehler! Ordner ist nicht vorhanden. ',
    'Success ! Folder updated successfully.' => 'Erfolg! Ordner erfolgreich aktualisiert. ',
    'Error ! Folder does not exist.' => 'Fehler! Ordner existiert nicht. ',
    'Success ! Folder deleted successfully.' => 'Erfolg! Ordner erfolgreich gelöscht. ',
    'Warning ! Folder doesnt exists!' => 'Warnung! Ordner existiert nicht!',
    'Warning ! Cannot create ticket, given email is blocked by admin.' => 'Warnung! Ticket kann nicht erstellt werden, da die angegebene E-Mail-Adresse vom Administrator blockiert wird. ',
    'Success ! Ticket has been created successfully.' => 'Erfolg! Ticket wurde erfolgreich erstellt. ',
    'Warning ! Can not create ticket, invalid details.' => 'Warnung! Ticket kann nicht erstellt werden, ungültige Angaben. ',
    'Warning ! Post size can not exceed 25MB' => 'Warnung! Die Postgröße darf 25 MB nicht überschreiten.',
    'Create Ticket Request' => 'Ticket erstellen',
    'Success ! Reply added successfully.' => 'Erfolgreich! Antwort erfolgreich hinzugefügt.',
    'Warning ! Reply field can not be blank.' => 'Warnung! Das Antwortfeld darf nicht leer sein.',
    'Success ! Rating has been successfully added.' => 'Erfolg! Die Bewertung wurde erfolgreich hinzugefügt. ',
    'Warning ! Invalid rating.' => 'Warnung! Ungültige Bewertung. ',
    'Error ! Can not add customer as a collaborator.' => 'Fehler! Kunde kann nicht als Mitbearbeiter hinzugefügt werden. ',
    'Success ! Collaborator added successfully.' => 'Erfolg! Mitbearbeiter erfolgreich hinzugefügt. ',
    'Error ! Collaborator is already added.' => 'Fehler! Der Mitbearbeiter wurde bereits hinzugefügt. ',
    'Success ! Collaborator removed successfully.' => 'Erfolg! Mitbearbeiter erfolgreich entfernt. ',
    'Error ! Invalid Collaborator.' => 'Fehler! Ungültiger Mitbearbeiter. ',
    'An unexpected error occurred. Please try again later.' => 'Ein unerwarteter Fehler ist aufgetreten. Bitte versuchen Sie es später noch einmal. ',
    'Feedback saved successfully.' => 'Feedback erfolgreich gespeichert.',
    'Feedback updated successfully.' => 'Feedback erfolgreich aktualisiert.',
    'Invalid feedback provided.' => 'Ungültiges Feedback angegeben.',
    'Article not found.' => 'Artikel nicht gefunden.',
    'You need to login to your account before can perform this action.' => 'Sie müssen sich bei Ihrem Konto anmelden, bevor Sie diese Aktion ausführen können.',
    'Warning! Please add valid Actions!' => 'Warnung! Bitte gültige Aktionen hinzufügen! ',
    'Warning! In Free Plan you can not change Events!' => 'Warnung! In Free Plan können Sie keine Events ändern! ',
    'Success! Prepared Response has been updated successfully.' => 'Erfolg! Die vorbereitete Antwort wurde erfolgreich aktualisiert. ',
    'Success! Prepared Response has been added successfully.' => 'Erfolg! Die vorbereitete Antwort wurde erfolgreich hinzugefügt. ',
    'Warning  This is not a valid request' => 'Warnung Dies ist keine gültige Anfrage',
    'Use Default Colors' => 'Standardfarben verwenden',
    'Masonry' => 'Mauerwerk',
    'Popular Article' => 'Populärer Artikel',
    'Manage Ticket Custom Fields' => 'Benutzerdefinierte Ticketfelder verwalten',
    'You dont have premission to edit this Prepared response' => 'Sie haben keine Berechtigung, diese vorbereitete Antwort zu bearbeiten.',
    'Save Prepared Response' => 'Vorbereitete Antwort speichern',
    'Success ! Prepared response removed successfully.' => 'Erfolg! Vorbereitete Antwort erfolgreich entfernt. ',
    'Warning! You are not allowed to perform this action.' => 'Warnung! Sie dürfen diese Aktion nicht ausführen. ',
    'Success! Workflow has been updated successfully.' => 'Erfolg! Der Workflow wurde erfolgreich aktualisiert. ',
    'Success! Workflow has been added successfully.' => 'Erfolg! Workflow wurde erfolgreich hinzugefügt. ',
    'Success! Order has been updated successfully.' => 'Erfolg! Bestellung wurde erfolgreich aktualisiert. ',
    'Success! Workflow has been removed successfully.' => 'Erfolg! Workflow wurde erfolgreich entfernt. ',
    'Mailbox successfully created.' => 'Postfach erfolgreich erstellt.',
    'Mailbox successfully updated.' => 'Postfach erfolgreich aktualisiert.',
    'Warning ! Bad request !' => 'Warnung! Ungültige Anfrage!',
    'Error! Given current password is incorrect.' => 'Fehler! Das angegebene aktuelle Passwort ist falsch. ',
    'Success ! Profile update successfully.' => 'Erfolg! Profil erfolgreich aktualisiert. ',
    'Error ! User with same email is already exist.' => 'Fehler! Benutzer mit derselben E-Mail-Adresse ist bereits vorhanden. ',
    'Success ! Agent updated successfully.' => 'Erfolg! Agent erfolgreich aktualisiert. ',
    'Success ! Agent removed successfully.' => 'Erfolg! Agent erfolgreich entfernt. ',
    'Warning ! You are allowed to remove account owners account.' => 'Warnung! Sie dürfen das Konto des Kontoinhabers entfernen.',
    'Error ! Invalid user id.' => 'Fehler! Ungültige Benutzer-ID.',
    'Success ! Filter has been saved successfully.' => 'Erfolgreich! Filter wurde erfolgreich gespeichert.',
    'Success ! Filter has been updated successfully.' => 'Erfolgreich! Filter wurde erfolgreich aktualisiert.',
    'Success ! Filter has been removed successfully.' => 'Erfolgreich! Filter wurde erfolgreich entfernt.',
    'Please check your mail for password update.' => 'Bitte überprüfen Sie Ihre E - Mails auf Passwortaktualisierung.',
    'This Email address is not registered with us.' => 'Diese E-Mail-Adresse ist bei uns nicht registriert.',
    'Success ! Customer saved successfully.' => 'Erfolgreich! Kunde erfolgreich gespeichert.',
    'Error ! User with same email already exist.' => 'Fehler! Benutzer mit derselben E-Mail existiert bereits.',
    'Success ! Customer information updated successfully.' => 'Erfolgreich! Kundenangaben wurden erfolgreich aktualisiert.',
    'Success ! Customer updated successfully.' => 'Erfolgreich! Kunde erfolgreich aktualisiert.',
    'Error ! Customer with same email already exist.' => 'Fehler! Kunde mit derselben E-Mail existiert bereits.',
    'unstarred Action Completed successfully' => 'nicht markierte Aktion erfolgreich abgeschlossen',
    'starred Action Completed successfully' => 'markierte Aktion erfolgreich abgeschlossen',
    'Success ! Customer removed successfully.' => 'Erfolgreich! Kunde erfolgreich entfernt.',
    'Error ! Invalid customer id.' => 'Fehler! Ungültige Kunden-ID.',
    'Success! Template has been updated successfully.' => 'Erfolg! Vorlage wurde erfolgreich aktualisiert.',
    'Success! Template has been added successfully.' => 'Erfolg! Vorlage wurde erfolgreich hinzugefügt.',
    'Success! Template has been deleted successfully.' => 'Erfolg! Vorlage wurde erfolgreich gelöscht.',
    'Warning! resource not found.' => 'Warnung! Ressource nicht gefunden.',
    'Warning! You can not remove predefined email template which is being used in workflow(s).' => 'Warnung! Sie können vordefinierte E-Mail-Vorlagen, die in Workflows verwendet werden, nicht entfernen.',
    'Success ! Email settings are updated successfully.' => 'Erfolgreich! E-Mail-Einstellungen wurden erfolgreich aktualisiert.',
    'Success ! Group information updated successfully.' => 'Erfolgreich! Gruppeninformationen wurden erfolgreich aktualisiert.',
    'Success ! Group information saved successfully.' => 'Erfolgreich! Gruppeninformationen erfolgreich gespeichert.',
    'Support Group removed successfully.' => 'Support Group erfolgreich entfernt.',
    'Success ! Privilege information saved successfully.' => 'Erfolgreich! Berechtigungsinformationen erfolgreich gespeichert.',
    'Privilege updated successfully.' => 'Privileg erfolgreich aktualisiert.',
    'Support Privilege removed successfully.' => 'Msgstr Support - Berechtigung erfolgreich entfernt.',
    'Success! Reply has been updated successfully.' => 'Erfolgreich! Die Antwort wurde erfolgreich aktualisiert.',
    'Success! Reply has been added successfully.' => 'Erfolgreich! Antwort wurde erfolgreich hinzugefügt.',
    'Success! Saved Reply has been deleted successfully' => 'Erfolgreich! Gespeicherte Antwort wurde erfolgreich gelöscht',
    'SwiftMailer configuration updated successfully.' => 'Die SwiftMailer-Konfiguration wurde erfolgreich aktualisiert.',
    'Swiftmailer configuration removed successfully.' => 'Msgstr Swiftmailer - Konfiguration erfolgreich entfernt.',
    'Success ! Team information saved successfully.' => 'Erfolg! Teaminformationen erfolgreich gespeichert.',
    'Success ! Team information updated successfully.' => 'Erfolgreich! Die Teaminformationen wurden erfolgreich aktualisiert.',
    'Support Team removed successfully.' => 'Msgstr Support - Team erfolgreich entfernt.',
    'Success! Reply has been added successfully' => 'Erfolgreich! Antwort wurde erfolgreich hinzugefügt',
    'Success ! Thread updated successfully.' => 'Erfolgreich! Thread erfolgreich aktualisiert.',
    'Error ! Reply field can not be blank.' => 'Fehler! Das Antwortfeld darf nicht leer sein.',
    'Success ! Thread removed successfully.' => 'Erfolgreich! Thread erfolgreich entfernt.',
    'Success ! Thread locked successfully' => 'Erfolg! Thread erfolgreich gesperrt',
    'Success ! Thread unlocked successfully' => 'Erfolg! Thread erfolgreich entsperrt',
    'Success ! Thread pinned successfully' => 'Erfolg! Thread erfolgreich gepinnt',
    'Error ! Invalid thread.' => 'Fehler! Ungültiger Thread.',
    'Could not create ticket, invalid details.' => 'Ticket konnte nicht erstellt werden, ungültige Angaben.',
    'Success ! Tag updated successfully.' => 'Erfolgreich! Tag erfolgreich aktualisiert.',
    'Error ! Customer can not be added as collaborator.' => 'Fehler! Kunde kann nicht als Mitbearbeiter hinzugefügt werden.',
    'Success ! Tag unassigned successfully.' => 'Erfolgreich! Tag nicht erfolgreich zugewiesen.',
    'Success ! Tag added successfully.' => 'Erfolgreich! Tag erfolgreich hinzugefügt.',
    'Please enter tag name.' => 'Bitte geben Sie den Tag-Namen ein.',
    'Error ! Invalid tag.' => 'Fehler! Ungültiges Tag.',
    'Success ! Type removed successfully.' => 'Erfolgreich! Typ erfolgreich entfernt.',
    'Success ! Ticket to label removed successfully.' => 'Erfolg! Ticket zum Etikett erfolgreich entfernt.',
    'Unable to retrieve support team details' => 'Support-Team-Details können nicht abgerufen werden',
    'Ticket support group updated successfully' => 'Ticket Support Group erfolgreich aktualisiert',
    'Unable to retrieve status details' => 'Statusdetails können nicht abgerufen werden',
    'Insufficient details provided.' => 'Msgstr Unzureichende Angaben gemacht.',
    'Error! Subject field is mandatory' => 'Fehler! Betreff ist Pflichtfeld',
    'Error! Reply field is mandatory' => 'Fehler! Antwortfeld ist obligatorisch',
    'Success ! Ticket has been updated successfully.' => 'Erfolg! Ticket wurde erfolgreich aktualisiert.',
    'Success ! Label updated successfully.' => 'Erfolgreich! Label erfolgreich aktualisiert.',
    'Error ! Invalid label id.' => 'Fehler! Ungültige Label-ID.',
    'Success ! Label removed successfully.' => 'Erfolg! Label erfolgreich entfernt.',
    'Success ! Label created successfully.' => 'Erfolg! Label erfolgreich erstellt.',
    'Error ! Label name can not be blank.' => 'Fehler! Der Labelname darf nicht leer sein.',
    'Success ! Ticket moved to trash successfully.' => 'Erfolgreich! Ticket wurde erfolgreich in den Papierkorb verschoben.',
    'Success! Ticket type saved successfully.' => 'Erfolgreich! Ticket-Typ erfolgreich gespeichert.',
    'Success! Ticket type updated successfully.' => 'Erfolgreich! Ticket-Typ erfolgreich aktualisiert.',
    'Error! Ticket type with same name already exist' => 'Fehler! Ticket-Typ mit gleichem Namen existiert bereits',
    'SAVE' => 'SPEICHERN',
    '# Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'Titel-Tags und Meta-Beschreibungen sind Teile des HTML-Codes im Header einer Webseite. Sie helfen Suchmaschinen, den Inhalt einer Seite zu verstehen. Das Titel-Tag und die Meta-Beschreibung einer Seite werden normalerweise angezeigt, wenn diese Seite in Suchmaschinenergebnissen angezeigt wird',
    'New Ticket Request' => 'Ticket erstellen',
    'Ticket Requests' => 'Tickets',
    'Tickets have been updated successfully' => 'Tickets wurden erfolgreich aktualisiert',
    'Please check your mail for password update' => 'Bitte überprüfen Sie Ihre E-Mails auf Passwort-Update',
    'This email address is not registered with us' => 'Diese E-Mail-Adresse ist nicht bei uns registriert',
    'You have already update password using this link if you wish to change password again click on forget password link here from login page' => 'Sie haben das Passwort bereits über diesen Link aktualisiert, wenn Sie das Passwort erneut ändern möchten. Klicken Sie hier auf der Anmeldeseite auf den Link Passwort vergessen',
    'Your password has been successfully updated. Login using updated password' => 'Ihr Passwort wurde erfolgreich aktualisiert. Melden Sie sich mit dem aktualisierten Passwort an',
    'Please try again, The passwords do not match' => 'Bitte versuchen Sie es erneut. Die Passwörter stimmen nicht überein',
    'Support Privilege removed successfully' => 'Support-Berechtigung erfolgreich entfernt',
    'Success! Saved Reply has been deleted successfully.' => 'Erfolg! Gespeicherte Antwort wurde erfolgreich gelöscht.',
    'SwiftMailer configuration created successfully.' => 'SwiftMailer-Konfiguration erfolgreich erstellt.',
    'No swiftmailer configurations found for mailer id:' => 'Für die Mailer-ID wurden keine Swiftmailer-Konfigurationen gefunden',
    'Reply content cannot be left blank.' => 'Der Antwortinhalt darf nicht leer bleiben.',
    'Reply added to the ticket and forwarded successfully.' => 'Antwort zum Ticket hinzugefügt und erfolgreich weitergeleitet.',
    'Success ! Thread pinned successfully.' => 'Erfolg! Thread erfolgreich gepinnt.',
    'Success ! unpinned removed successfully.' => 'Erfolg! nicht fixiert erfolgreich entfernt.',
    'Unable to retrieve priority details' => 'Prioritätsdetails können nicht abgerufen werden',
    'Ticket support team updated successfully' => 'Ticket-Support-Team erfolgreich aktualisiert',
    'Ticket assigned to support group ' => 'Ticket der Support-Gruppe zugewiesen',
    'Mailbox configuration removed successfully.' => 'Postfachkonfiguration erfolgreich entfernt.',
    'visit our website' => 'unsere Webseite besuchen',
    'Cookie Usage Policy' => 'Cookie-Verwendungsrichtlinien',
    'cookie' => 'Cookie',
    'cookies' => 'Cookies',
    'HELP' => 'HILFE',
    'Home' => 'Startseite',
    'Cookie Policy' => 'Cookie-Richtlinie',
    'Prev' => 'Zurück',
    'Ticket query message' => 'Beschreibung',
    'Select type' => 'Typ wählen',
    'Search KnowledgeBase' => 'Suchen in Wissensbasis',
    'You cant merge an account with itself.' => 'Konto kann nicht mit sich selbst zusammengeführt werden.',
    'Edit Profile' => 'Profil bearbeiten',
    'Customer Login' => 'Kundenlogin',
    'Contact Us' => 'Kontaktiere uns',
    'If you have ever contacted our support previously, your account would have already been created.' => 'Wenn Sie schon einmal Kontakt mit unserem Support aufgenommen haben, wurde Ihr Konto bereits erstellt.',
    'support' => 'Support',
    'HelpDesk' => 'HelpDesk',
    'Enter search keyword' => 'Suchbegriff eingeben',
    'Browse via Folders' => 'Über Ordner browsen',
    'Looking for something that is queried generally? Choose a relevant folder from below to explore possible solutions' => 'Suchen Sie etwas, das allgemein abgefragt wird? Wählen Sie einen relevanten Ordner aus, um nach möglichen Lösungen zu suchen',
    'Unable to find an answer?' => 'Keine Antwort gefunden?',
    'Looking for anything specific article which resides in general queries? Just browse the various relevant folders and categories and then you will find the desired article.' => 'Suchen Sie nach einem bestimmten Artikel, der sich in allgemeinen Fragen befindet? Durchsuchen Sie einfach die verschiedenen relevanten Ordner und Kategorien und finden Sie den gewünschten Artikel.',
    'Popular Articles' => 'populäre Artikel',
    'Here are some of the most popular articles, which helped number of users to get their queries and questions resolved.' => 'Im Folgenden finden Sie einige der beliebtesten Artikel, mit deren Hilfe die Anzahl der Benutzer ihre Fragen und Probleme gelöst hat.',
    'Browse via Categories' => 'Durchsuchen Sie die Kategorien',
    'Looking for something specific? Choose a relevant category from below to explore possible solutions' => 'Auf der Suche nach etwas Bestimmtem? Wählen Sie eine relevante Kategorie aus, um nach möglichen Lösungen zu suchen',
    'No Categories Found!' => 'Keine Kategorien gefunden',
    'Powered by' => 'Unterstützt von',
    'Forgot Password' => 'Passwort vergessen',
    'Enter your email address and we will send you an email with instructions to update your login credentials.' => 'E-Mail eingeben um die Anmeldung wiederherzustellen',
    'Send Mail' => 'Mail senden',
    'Status:' => 'Status:',
    'Sign In to %websitename%' => 'Anmelden bei %websitename%',
    'Enter your name' => 'Name eingeben',
    'Enter your email' => 'E-Mail Adresse eingeben',
    'Learn more about %deliveryStatus%.' => 'Lerne mehr über %deliveryStatus%.',
    'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.' => 'Einige unserer Seiten verwenden %cookies% und andere Tracking-Technologien. Ein %cookie% ist eine kleine Textdatei, die beispielsweise zum Sammeln von Informationen über Site-Aktivitäten verwendet werden kann. Einige %cookies% und andere Technologien können dazu dienen, persönliche Informationen abzurufen, die zuvor von einem Website-Benutzer angegeben wurden. Sie können %cookies% blockieren oder vorhandene %cookies% löschen, indem Sie die entsprechende Einstellung in Ihrem Browser vornehmen. Bitte konsultieren Sie das %help%-Menü Ihres Browsers, um zu erfahren, wie Sie dies tun können. Wenn Sie %cookies% blockieren oder löschen, kann die Nützlichkeit unserer Website beeinträchtigt werden.',
    'To know more about how our privacy policy works, please %websiteLink%.' => 'Weitere Informationen zur Funktionsweise unserer Datenschutzbestimmungen erhalten Sie auf %websiteLink%.',
    'This field contain maximum 40 charectures.' => 'Dieses Feld enthält maximal 40 Zeichen.',
    'This field contain maximum 50 charectures.' => 'Dieses Feld enthält maximal 50 Zeichen.',
    'Time' => 'Zeit',
    'Links' => 'Links',
    'Broadcast Message' => 'Schlagzeile',
    'Wide Logo' => 'Logo breit',
    'Upload an Image (200px x 48px) in</br> PNG or JPG Format' => 'Bild hochladen (200px x 48px)</br>PNG oder JPG Format',
    'It will be shown as Logo on Knowledgebase and Helpdesk' => 'Logo in Wissensbasis und Helpdesk',
    'Enable front end website and knowledgebase for customer(s)' => 'Frontend und Wissensbasis für Kunden erlauben',
    'Brand Color' => 'Marken-Farbe',
    'Page Background Color' => 'Seiten-Hintergrundfarbe',
    'Header Background Color' => 'Header Hintergrundfarbe',
    'Banner Background Color' => 'Banner Hintergrundfarbe',
    'Page Link Color' => 'Seitenlink Farbe',
    'Page Link Hover Color' => 'Seitenlink Hover Farbe',
    'Article Text Color' => 'Artikel-Textfarbe',
    'Tag Line' => 'Tag Line',
    'Hi! how can we help?' => 'Wie können wir helfen?',
    'Layout' => 'Layout',
    'Ticket Create Option' => 'Ticket Erfassen Option',
    'Login Required To Create Tickets' => 'Anmeldung notwendig für neue Tickets',
    'Remove Customer Login/Signin Button' => 'Kundenanmeldung Button entfernen',
    'Disable Customer Login' => 'Kundenanmeldung deaktivieren',
    'Meta Description (Recommended)' => 'Meta Beschreibung (empfohlen)',
    'Meta Keywords (Recommended)' => 'Meta Schlüsselwörter (empfohlen)',
    'Header Link' => 'Header Link',
    'URL (with http:// or https://)' => 'URL (http:// oder https://)',
    'Footer Link' => 'Footer Link',
    'Custom CSS (Optional)' => 'Custom CSS (Optional)',
    'It will be add to the frontend knowledgebase only' => 'Wird nur in Frontend Wissensbasis hinzugefügt',
    'Custom Javascript (Optional)' => 'Custom Javascript (Optional)',
    'Broadcast message content to show on helpdesk' => 'Schlagzeile wird im Helpdesk angezeigt',
    'From' => 'Von',
    'Time duration between which message will be displayed(if applicable)' => 'Zeitspanne in der die Schlagzeile gezeigt wird',
    'Broadcasting Status' => 'Schlagzeilestatus',
    'Broadcasting is Active' => 'Schlagzeile aktiv',
    'Choose a default company timezone' => 'Standard-Zeitzone wählen',
    'Date Time Format' => 'Datumsformat',
    'Choose a format to convert date to specified date time format' => 'Format wählen',
    'An empty file is not allowed.' => 'Leere Datei nicht erlaubt',
    'File size must not be greater than 200KB !!' => 'Dateigrösse darf nicht 200KB überschreiten',
    'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!' => 'Bilddatei hochladen (nur JPEG, JPG, PNG erlaubt)',
    'comma "," separated' => 'Kommagetrennt',
    'Provide a valid url(with protocol)' => 'Gültige URL (mit Protokoll)',
    'Low' => 'Niedrig',
    'Medium' => 'Mittel',
    'High' => 'Hoch',
    'Urgent' => 'Dringend',
    'Reset Password' => 'Passwort zurücksetzen',
    'Enter your new password below to update your login credentials' => 'Geben Sie unten Ihr neues Passwort ein, um Ihre Anmeldeinformationen zu aktualisieren',
    'Save Password' => 'Passwort speichern',
    'Rate Support' => 'Bewerten Sie Support',
    'I am very Sad' => 'Ich bin sehr traurig',
    'I am Sad' => 'Ich bin traurig',
    'I am Neutral' => 'Ich bin neutral',
    'I am Happy' => 'Ich bin fröhlich',
    'I am Very Happy' => 'Ich bin sehr glücklich',
    'Kudos' => 'Respekt',
    'kudos' => 'Respekt',
    'Very Sad' => 'Sehr traurig',
    'Sad' => 'Traurig',
    'Neutral' => 'Neutral',
    'Happy' => 'glücklich',
    'Very Happy' => 'Sehr glücklich',
    'Star(s)' => 'Sterne',
    'Warning ! Swiftmailer not working. An error has occurred while sending emails!' => 'Warnung ! Swiftmailer funktioniert nicht. Beim Senden von E-Mails ist ein Fehler aufgetreten!',
    'Invalid credentials.' => 'Ungültige Zugangsdaten',
    'Success ! Project cache cleared successfully.' => 'Erfolg ! Projektcache erfolgreich gelöscht.',
    'clear cache' => 'Cache leeren',
    'Last Updated' => 'Letzte Aktualisierung',
    'Error! Something went wrong.' => 'Fehler! Etwas ist schief gelaufen.',
    'We were not able to find the page you are looking for.' => 'Wir konnten die von Ihnen gesuchte Seite nicht finden.',
    'Page not found' => 'Seite nicht gefunden',
    'Forbidden' => 'Verboten',
    'You don’t have the necessary permissions to access this Web page :(' => 'Sie haben nicht die erforderlichen Berechtigungen, um auf diese Webseite zuzugreifen :(',
    'Internal server error' => 'Interner Serverfehler',
    'Our system has goofed up for a while, but good part is it won\'t last long' => 'Unser System hat eine Weile vermasselt, aber das Gute daran ist, es wird nicht lange halten',
    'Unknown Error' => 'Unbekannter Fehler',
    'We are quite confused about how did you land here:/' => 'Wir sind ziemlich verwirrt darüber, wie du hier gelandet bist :/',
    'Few of the links which may help you to get back on the track -' => 'Einige der Links, die Ihnen helfen können, wieder auf die Spur zu kommen -',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This value should be a valid expression.' => 'This value should be a valid expression.',
    'This value is not a valid CSS color.' => 'This value is not a valid CSS color.',
    'This value is not a valid CIDR notation.' => 'This value is not a valid CIDR notation.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'The value of the netmask should be between {{ min }} and {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.',
    'The password strength is too low. Please use a stronger password.' => 'The password strength is too low. Please use a stronger password.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'This value contains characters that are not allowed by the current restriction-level.',
    'Using invisible characters is not allowed.' => 'Using invisible characters is not allowed.',
    'Mixing numbers from different scripts is not allowed.' => 'Mixing numbers from different scripts is not allowed.',
    'Using hidden overlay characters is not allowed.' => 'Using hidden overlay characters is not allowed.',
    'This form should not contain extra fields.' => 'This form should not contain extra fields.',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'The uploaded file was too large. Please try to upload a smaller file.',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'The CSRF token is invalid. Please try to resubmit the form.',
    'This value is not a valid HTML5 color.' => 'This value is not a valid HTML5 color.',
    'Please enter a valid birthdate.' => 'Please enter a valid birthdate.',
    'The selected choice is invalid.' => 'The selected choice is invalid.',
    'The collection is invalid.' => 'The collection is invalid.',
    'Please select a valid color.' => 'Please select a valid color.',
    'Please select a valid country.' => 'Please select a valid country.',
    'Please select a valid currency.' => 'Please select a valid currency.',
    'Please choose a valid date interval.' => 'Please choose a valid date interval.',
    'Please enter a valid date and time.' => 'Please enter a valid date and time.',
    'Please enter a valid date.' => 'Please enter a valid date.',
    'Please select a valid file.' => 'Please select a valid file.',
    'The hidden field is invalid.' => 'The hidden field is invalid.',
    'Please enter an integer.' => 'Please enter an integer.',
    'Please select a valid language.' => 'Please select a valid language.',
    'Please select a valid locale.' => 'Please select a valid locale.',
    'Please enter a valid money amount.' => 'Please enter a valid money amount.',
    'Please enter a number.' => 'Please enter a number.',
    'The password is invalid.' => 'The password is invalid.',
    'Please enter a percentage value.' => 'Please enter a percentage value.',
    'The values do not match.' => 'The values do not match.',
    'Please enter a valid time.' => 'Please enter a valid time.',
    'Please select a valid timezone.' => 'Please select a valid timezone.',
    'Please enter a valid URL.' => 'Please enter a valid URL.',
    'Please enter a valid search term.' => 'Please enter a valid search term.',
    'Please provide a valid phone number.' => 'Please provide a valid phone number.',
    'The checkbox has an invalid value.' => 'The checkbox has an invalid value.',
    'Please enter a valid email address.' => 'Please enter a valid email address.',
    'Please select a valid option.' => 'Please select a valid option.',
    'Please select a valid range.' => 'Please select a valid range.',
    'Please enter a valid week.' => 'Please enter a valid week.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Too many failed login attempts, please try again in %minutes% minute.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Too many failed login attempts, please try again in %minutes% minutes.',
  ),
  'KnpPaginatorBundle' => 
  array (
    'label_previous' => 'Previous',
    'label_next' => 'Next',
    'filter_searchword' => 'Searchword...',
  ),
  'messages' => 
  array (
    'Signed in as' => 'Signed in as',
    'Your Profile' => 'Your Profile',
    'Create Ticket' => 'Create Ticket',
    'Create Agent' => 'Create Agent',
    'Create Customer' => 'Create Customer',
    'Sign Out' => 'Sign Out',
    'Default Language (Optional)' => 'Default Language (Optional)',
    'Username/Email' => 'Username/Email',
    'create new' => 'create new',
    'Ticket Information' => 'Ticket Information',
    'CC/BCC' => 'CC/BCC',
    'Success! Label created successfully.' => 'Success! Label created successfully.',
    'Success! Label removed successfully.' => 'Success! Label removed successfully.',
    'Reports' => 'Reports',
    'Rating' => 'Rating',
    'Kudos Rating' => 'Kudos Rating',
    'Remove profile picture' => 'Remove profile picture',
    'Success ! Profile updated successfully.' => 'Success ! Profile updated successfully.',
    'Howdy' => 'Howdy',
    'Form successfully updated.' => 'Form successfully updated.',
    'NEW FORM' => 'NEW FORM',
    'Text Box' => 'Text Box',
    'Text Area' => 'Text Area',
    'Select' => 'Select',
    'Radio' => 'Radio',
    'Checkbox' => 'Checkbox',
    'Date' => 'Date',
    'Both Date and Time' => 'Both Date and Time',
    'Choose a status' => 'Choose a status',
    'Choose a group' => 'Choose a group',
    'Choose your default timeformat' => 'Choose your default timeformat',
    'Can manage Group\'s Saved Reply' => 'Can manage Group\'s Saved Reply',
    'Can manage agent activity' => 'Can manage agent activity',
    'Slug is the url identity of this article. We will help you to create valid slug at time of typing.' => 'Slug is the url identity of this article. We will help you to create valid slug at time of typing.',
    'The URL for this article' => 'The URL for this article',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A page\'s title tag and meta description are usually shown whenever that page appears in search engine results' => 'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A page\'s title tag and meta description are usually shown whenever that page appears in search engine results',
    'comma separated (,)' => 'comma separated (,)',
    'Article Title' => 'Article Title',
    'Start typing few charactors and add set of relevant article from the list' => 'Start typing few charactors and add set of relevant article from the list',
    'Success! Announcement data saved successfully.' => 'Success! Announcement data saved successfully.',
    'Success! Category has been added successfully.' => 'Success! Category has been added successfully.',
    'Success ! Agent added successfully.' => 'Success ! Agent added successfully.',
    'Success! Privilege information saved successfully.' => 'Success! Privilege information saved successfully.',
    'Edit Prepared Response' => 'Edit Prepared Response',
    'Success! Type removed successfully.' => 'Success! Type removed successfully.',
    'No results available' => 'No results available',
    'Success ! Prepared Response applied successfully.' => 'Success ! Prepared Response applied successfully.',
    'Note added to ticket successfully.' => 'Note added to ticket successfully.',
    'Ticket status update to Spam' => 'Ticket status update to Spam',
    'Ticket status update to Closed' => 'Ticket status update to Closed',
    'Success! Label updated successfully.' => 'Success! Label updated successfully.',
    'Success ! Helpdesk details saved successfully' => 'Success ! Helpdesk details saved successfully',
    'Can manage marketing announcement' => 'Can manage marketing announcement',
    'User Forgot Password' => 'User Forgot Password',
    'Agent Deleted' => 'Agent Deleted',
    'Agent Update' => 'Agent Update',
    'Customer Update' => 'Customer Update',
    'Customer Deleted' => 'Customer Deleted',
    'Agent Updated' => 'Agent Updated',
    'Agent Reply' => 'Agent Reply',
    'Collaborator Added' => 'Collaborator Added',
    'Collaborator Reply' => 'Collaborator Reply',
    'Customer Reply' => 'Customer Reply',
    'Ticket Deleted' => 'Ticket Deleted',
    'Group Updated' => 'Group Updated',
    'Note Added' => 'Note Added',
    'Priority Updated' => 'Priority Updated',
    'Status Updated' => 'Status Updated',
    'Team Updated' => 'Team Updated',
    'Thread Updated' => 'Thread Updated',
    'Type Updated' => 'Type Updated',
    'From Email' => 'From Email',
    'To Email' => 'To Email',
    'Is Equal To' => 'Is Equal To',
    'Is Not Equal To' => 'Is Not Equal To',
    'Contains' => 'Contains',
    'Does Not Contain' => 'Does Not Contain',
    'Starts With' => 'Starts With',
    'Ends With' => 'Ends With',
    'Before On' => 'Before On',
    'After On' => 'After On',
    'Mail To User' => 'Mail To User',
    'Transfer Tickets' => 'Transfer Tickets',
    'Mail To Customer' => 'Mail To Customer',
    'Permanently delete from Inbox' => 'Permanently delete from Inbox',
    'Agent Activity' => 'Agent Activity',
    'Report From' => 'Report From',
    'Search Agent' => 'Search Agent',
    'Agent Last Reply' => 'Agent Last Reply',
    'View analytics and insights to serve a better experience for your customers' => 'Analytics and insight regarding your workflow',
    'Marketing Announcement' => 'Marketing Announcement',
    'Advertisment' => 'Advertisment',
    'Announcement' => 'Announcement',
    'New Announcement' => 'New Announcement',
    'Add Announcement' => 'Add Announcement',
    'Edit Announcement' => 'Edit Announcement',
    'Promo Text' => 'Promo Text',
    'Promo Tag' => 'Promo Tag',
    'Choose a promo tag' => 'Choose a promo tag',
    'Tag-Color' => 'Tag-Color',
    'Tag background color' => 'Tag background color',
    'Link Text' => 'Link Text',
    'Link URL' => 'Link URL',
    'Apps' => 'Apps',
    'Integrate apps as per your needs to get things done faster than ever' => 'Install new custom apps to boost your productivity.',
    'Explore Apps' => 'Explore Apps',
    'Form Builder' => 'Form Builder',
    'Knowledgebase' => 'Knowledgebase',
    'Knowledgebase is a source of rigid and complex information which helps Customers to help themselves' => 'Help your customers help themselves! Save time on support by building your knowledge base.',
    'Articles' => 'Articles',
    'Categories' => 'Categories',
    'Folders' => 'Folders',
    'FOLDERS' => 'FOLDERS',
    'Productivity' => 'Productivity',
    'Automate your processes by creating set of rules and presets to respond faster to the tickets' => 'Create automation rules to speed up your workflow.',
    'Prepared Responses' => 'Prepared Responses',
    'Saved Replies' => 'Saved Replies',
    'Edit Saved Reply' => 'Edit Saved Reply',
    'Ticket Types' => 'Ticket Types',
    'Workflows' => 'Workflows',
    'Settings' => 'Settings',
    'Manage your Brand Identity, Company Information and other details at a glance' => 'Manage your Brand Identity, Company Information and other details at a glance',
    'Branding' => 'Branding',
    'Custom Fields' => 'Custom Fields',
    'Email Settings' => 'Email Settings',
    'Email Templates' => 'Email Templates',
    'Mailbox' => 'Mailbox',
    'Spam Settings' => 'Spam Settings',
    'Swift Mailer' => 'Swift Mailer',
    'Tags' => 'Tags',
    'Users' => 'Users',
    'Control your Groups, Teams, Agents and Customers' => 'Manage your Groups, Teams, Agents and Customers',
    'Agents' => 'Agents',
    'Customers' => 'Customers',
    'Groups' => 'Groups',
    'Privileges' => 'Privileges',
    'Teams' => 'Teams',
    'Applications' => 'Applications',
    'ECommerce Order Syncronization' => 'eCommerce Order Syncronization',
    'Import ecommerce order details to your support tickets from different available platforms' => 'Import eCommerce order details to your support tickets from different available platforms',
    'Search' => 'Search',
    'Sort By' => 'Sort By',
    'Sort By:' => 'Sort By:',
    'Status' => 'Status',
    'Created At' => 'Created At',
    'Name' => 'Name',
    'All' => 'All',
    'Published' => 'Published',
    'Draft' => 'Draft',
    'New Folder' => 'New Folder',
    'Create Knowledgebase Folder' => 'Create Knowledgebase Folder',
    'You did not add any folder to your Knowledgebase yet, Create your first Folder and start adding Categories/Articles to make your customers help themselves.' => 'You don\'t have any folders yet! Create your first folder and start adding articles.',
    'Clear Filters' => 'Clear Filters',
    'Back' => 'Back',
    'Open' => 'Open',
    'Pending' => 'Pending',
    'Answered' => 'Answered',
    'Resolved' => 'Resolved',
    'Closed' => 'Closed',
    'Spam' => 'Spam',
    'New' => 'New',
    'UnAssigned' => 'Unassigned',
    'UnAnswered' => 'Unanswered',
    'My Tickets' => 'My Tickets',
    'Starred' => 'Starred',
    'Trashed' => 'Trashed',
    'New Label' => 'New Label',
    'Tickets' => 'Tickets',
    'Ticket Id' => 'Ticket Id',
    'Last Replied' => 'Last Replied',
    'Assign To' => 'Assign To',
    'After Reply' => 'After Reply',
    'Customer Email' => 'Customer Email',
    'Customer Name' => 'Customer Name',
    'Assets Visibility' => 'Assets Visibility',
    'Channel/Source' => 'Channel/Source',
    'Channel' => 'Channel',
    'Website' => 'Website',
    'Timestamp' => 'Timestamp',
    'TimeStamp' => 'TimeStamp',
    'Team' => 'Team',
    'Type' => 'Type',
    'Replies' => 'Replies',
    'Agent' => 'Agent',
    'ID' => 'ID',
    'Subject' => 'Subject',
    'Last Reply' => 'Last Reply',
    'Filter View' => 'Filter View',
    'Please select CAPTCHA' => 'Please select CAPTCHA',
    'Warning ! Please select correct CAPTCHA !' => 'CAPTCHA Failed, please try again',
    'reCAPTCHA Setting' => 'reCAPTCHA Setting',
    'reCAPTCHA Site Key' => 'reCAPTCHA Site Key',
    'reCAPTCHA Secret key' => 'reCAPTCHA Secret key',
    'reCAPTCHA Status' => 'reCAPTCHA Status',
    'reCAPTCHA is Active' => 'reCAPTCHA is Active',
    'Save set of filters as a preset to stay more productive' => 'Save filters as preset',
    'Saved Filters' => 'Saved Filters',
    'No saved filter created' => 'No saved filter created',
    'Customer' => 'Customer',
    'Priority' => 'Priority',
    'Tag' => 'Tag',
    'Source' => 'Source',
    'Before' => 'Before',
    'After' => 'After',
    'Replies less than' => 'Replies less than',
    'Replies more than' => 'Replies more than',
    'Clear All' => 'Clear All',
    'Account' => 'Account',
    'Profile' => 'Profile',
    'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format' => 'Upload a Profile Image (100px x 100px)<br> in PNG or JPG Format',
    'First Name' => 'First Name',
    'Last Name' => 'Last Name',
    'Email' => 'Email',
    'Contact Number' => 'Contact Number',
    'Timezone' => 'Timezone',
    'Africa/Abidjan' => 'Africa/Abidjan',
    'Africa/Accra' => 'Africa/Accra',
    'Africa/Addis_Ababa' => 'Africa/Addis_Ababa',
    'Africa/Algiers' => 'Africa/Algiers',
    'Africa/Asmara' => 'Africa/Asmara',
    'Africa/Bamako' => 'Africa/Bamako',
    'Africa/Bangui' => 'Africa/Bangui',
    'Africa/Banjul' => 'Africa/Banjul',
    'Africa/Bissau' => 'Africa/Bissau',
    'Africa/Blantyre' => 'Africa/Blantyre',
    'Africa/Brazzaville' => 'Africa/Brazzaville',
    'Africa/Bujumbura' => 'Africa/Bujumbura',
    'Africa/Cairo' => 'Africa/Cairo',
    'Africa/Casablanca' => 'Africa/Casablanca',
    'Africa/Ceuta' => 'Africa/Ceuta',
    'Africa/Conakry' => 'Africa/Conakry',
    'Africa/Dakar' => 'Africa/Dakar',
    'Africa/Dar_es_Salaam' => 'Africa/Dar_es_Salaam',
    'Africa/Djibouti' => 'Africa/Djibouti',
    'Africa/Douala' => 'Africa/Douala',
    'Africa/El_Aaiun' => 'Africa/El_Aaiun',
    'Africa/Freetown' => 'Africa/Freetown',
    'Africa/Gaborone' => 'Africa/Gaborone',
    'Africa/Harare' => 'Africa/Harare',
    'Africa/Johannesburg' => 'Africa/Johannesburg',
    'Africa/Juba' => 'Africa/Juba',
    'Africa/Kampala' => 'Africa/Kampala',
    'Africa/Khartoum' => 'Africa/Khartoum',
    'Africa/Kigali' => 'Africa/Kigali',
    'Africa/Kinshasa' => 'Africa/Kinshasa',
    'Africa/Lagos' => 'Africa/Lagos',
    'Africa/Libreville' => 'Africa/Libreville',
    'Africa/Lome' => 'Africa/Lome',
    'Africa/Luanda' => 'Africa/Luanda',
    'Africa/Lubumbashi' => 'Africa/Lubumbashi',
    'Africa/Lusaka' => 'Africa/Lusaka',
    'Africa/Malabo' => 'Africa/Malabo',
    'Africa/Maputo' => 'Africa/Maputo',
    'Africa/Maseru' => 'Africa/Maseru',
    'Africa/Mbabane' => 'Africa/Mbabane',
    'Africa/Mogadishu' => 'Africa/Mogadishu',
    'Africa/Monrovia' => 'Africa/Monrovia',
    'Africa/Nairobi' => 'Africa/Nairobi',
    'Africa/Ndjamena' => 'Africa/Ndjamena',
    'Africa/Niamey' => 'Africa/Niamey',
    'Africa/Nouakchott' => 'Africa/Nouakchott',
    'Africa/Ouagadougou' => 'Africa/Ouagadougou',
    'Africa/Porto-Novo' => 'Africa/Porto-Novo',
    'Africa/Sao_Tome' => 'Africa/Sao_Tome',
    'Africa/Tripoli' => 'Africa/Tripoli',
    'Africa/Tunis' => 'Africa/Tunis',
    'Africa/Windhoek' => 'Africa/Windhoek',
    'America/Adak' => 'America/Adak',
    'America/Anchorage' => 'America/Anchorage',
    'America/Anguilla' => 'America/Anguilla',
    'America/Antigua' => 'America/Antigua',
    'America/Araguaina' => 'America/Araguaina',
    'America/Argentina/Buenos_Aires' => 'America/Argentina/Buenos_Aires',
    'America/Argentina/Catamarca' => 'America/Argentina/Catamarca',
    'America/Argentina/Cordoba' => 'America/Argentina/Cordoba',
    'America/Argentina/Jujuy' => 'America/Argentina/Jujuy',
    'America/Argentina/La_Rioja' => 'America/Argentina/La_Rioja',
    'America/Argentina/Mendoza' => 'America/Argentina/Mendoza',
    'America/Argentina/Rio_Gallegos' => 'America/Argentina/Rio_Gallegos',
    'America/Argentina/Salta' => 'America/Argentina/Salta',
    'America/Argentina/San_Juan' => 'America/Argentina/San_Juan',
    'America/Argentina/San_Luis' => 'America/Argentina/San_Luis',
    'America/Argentina/Tucuman' => 'America/Argentina/Tucuman',
    'America/Argentina/Ushuaia' => 'America/Argentina/Ushuaia',
    'America/Aruba' => 'America/Aruba',
    'America/Asuncion' => 'America/Asuncion',
    'America/Atikokan' => 'America/Atikokan',
    'America/Bahia' => 'America/Bahia',
    'America/Bahia_Banderas' => 'America/Bahia_Banderas',
    'America/Barbados' => 'America/Barbados',
    'America/Belem' => 'America/Belem',
    'America/Belize' => 'America/Belize',
    'America/Blanc-Sablon' => 'America/Blanc-Sablon',
    'America/Boa_Vista' => 'America/Boa_Vista',
    'America/Bogota' => 'America/Bogota',
    'America/Boise' => 'America/Boise',
    'America/Cambridge_Bay' => 'America/Cambridge_Bay',
    'America/Campo_Grande' => 'America/Campo_Grande',
    'America/Cancun' => 'America/Cancun',
    'America/Caracas' => 'America/Caracas',
    'America/Cayenne' => 'America/Cayenne',
    'America/Cayman' => 'America/Cayman',
    'America/Chicago' => 'America/Chicago',
    'America/Chihuahua' => 'America/Chihuahua',
    'America/Costa_Rica' => 'America/Costa_Rica',
    'America/Creston' => 'America/Creston',
    'America/Cuiaba' => 'America/Cuiaba',
    'America/Curacao' => 'America/Curacao',
    'America/Danmarkshavn' => 'America/Danmarkshavn',
    'America/Dawson' => 'America/Dawson',
    'America/Dawson_Creek' => 'America/Dawson_Creek',
    'America/Denver' => 'America/Denver',
    'America/Detroit' => 'America/Detroit',
    'America/Dominica' => 'America/Dominica',
    'America/Edmonton' => 'America/Edmonton',
    'America/Eirunepe' => 'America/Eirunepe',
    'America/El_Salvador' => 'America/El_Salvador',
    'America/Fort_Nelson' => 'America/Fort_Nelson',
    'America/Fortaleza' => 'America/Fortaleza',
    'America/Glace_Bay' => 'America/Glace_Bay',
    'America/Godthab' => 'America/Godthab',
    'America/Goose_Bay' => 'America/Goose_Bay',
    'America/Grand_Turk' => 'America/Grand_Turk',
    'America/Grenada' => 'America/Grenada',
    'America/Guadeloupe' => 'America/Guadeloupe',
    'America/Guatemala' => 'America/Guatemala',
    'America/Guayaquil' => 'America/Guayaquil',
    'America/Guyana' => 'America/Guyana',
    'America/Halifax' => 'America/Halifax',
    'America/Havana' => 'America/Havana',
    'America/Hermosillo' => 'America/Hermosillo',
    'America/Indiana/Indianapolis' => 'America/Indiana/Indianapolis',
    'America/Indiana/Knox' => 'America/Indiana/Knox',
    'America/Indiana/Marengo' => 'America/Indiana/Marengo',
    'America/Indiana/Petersburg' => 'America/Indiana/Petersburg',
    'America/Indiana/Tell_City' => 'America/Indiana/Tell_City',
    'America/Indiana/Vevay' => 'America/Indiana/Vevay',
    'America/Indiana/Vincennes' => 'America/Indiana/Vincennes',
    'America/Indiana/Winamac' => 'America/Indiana/Winamac',
    'America/Inuvik' => 'America/Inuvik',
    'America/Iqaluit' => 'America/Iqaluit',
    'America/Jamaica' => 'America/Jamaica',
    'America/Juneau' => 'America/Juneau',
    'America/Kentucky/Louisville' => 'America/Kentucky/Louisville',
    'America/Kentucky/Monticello' => 'America/Kentucky/Monticello',
    'America/Kralendijk' => 'America/Kralendijk',
    'America/La_Paz' => 'America/La_Paz',
    'America/Lima' => 'America/Lima',
    'America/Los_Angeles' => 'America/Los_Angeles',
    'America/Lower_Princes' => 'America/Lower_Princes',
    'America/Maceio' => 'America/Maceio',
    'America/Managua' => 'America/Managua',
    'America/Manaus' => 'America/Manaus',
    'America/Marigot' => 'America/Marigot',
    'America/Martinique' => 'America/Martinique',
    'America/Matamoros' => 'America/Matamoros',
    'America/Mazatlan' => 'America/Mazatlan',
    'America/Menominee' => 'America/Menominee',
    'America/Merida' => 'America/Merida',
    'America/Metlakatla' => 'America/Metlakatla',
    'America/Mexico_City' => 'America/Mexico_City',
    'America/Miquelon' => 'America/Miquelon',
    'America/Moncton' => 'America/Moncton',
    'America/Monterrey' => 'America/Monterrey',
    'America/Montevideo' => 'America/Montevideo',
    'America/Montserrat' => 'America/Montserrat',
    'America/Nassau' => 'America/Nassau',
    'America/New_York' => 'America/New_York',
    'America/Nipigon' => 'America/Nipigon',
    'America/Nome' => 'America/Nome',
    'America/Noronha' => 'America/Noronha',
    'America/North_Dakota/Beulah' => 'America/North_Dakota/Beulah',
    'America/North_Dakota' => 'America/North_Dakota',
    'America/Ojinaga' => 'America/Ojinaga',
    'America/Panama' => 'America/Panama',
    'America/Pangnirtung' => 'America/Pangnirtung',
    'America/Paramaribo' => 'America/Paramaribo',
    'America/Phoenix' => 'America/Phoenix',
    'America/Port-au-Prince' => 'America/Port-au-Prince',
    'America/Port_of_Spain' => 'America/Port_of_Spain',
    'America/Porto_Velho' => 'America/Porto_Velho',
    'America/Puerto_Rico' => 'America/Puerto_Rico',
    'America/Punta_Arenas' => 'America/Punta_Arenas',
    'America/Rainy_River' => 'America/Rainy_River',
    'America/Rankin_Inlet' => 'America/Rankin_Inlet',
    'America/Recife' => 'America/Recife',
    'America/Regina' => 'America/Regina',
    'America/Resolute' => 'America/Resolute',
    'America/Rio_Branco' => 'America/Rio_Branco',
    'America/Santarem' => 'America/Santarem',
    'America/Santiago' => 'America/Santiago',
    'America/Santo_Domingo' => 'America/Santo_Domingo',
    'America/Sao_Paulo' => 'America/Sao_Paulo',
    'America/Scoresbysund' => 'America/Scoresbysund',
    'America/Sitka' => 'America/Sitka',
    'America/St_Barthelemy' => 'America/St_Barthelemy',
    'America/St_Johns' => 'America/St_Johns',
    'America/St_Kitts' => 'America/St_Kitts',
    'America/St_Lucia' => 'America/St_Lucia',
    'America/St_Thomas' => 'America/St_Thomas',
    'America/St_Vincent' => 'America/St_Vincent',
    'America/Swift_Current' => 'America/Swift_Current',
    'America/Tegucigalpa' => 'America/Tegucigalpa',
    'America/Thule' => 'America/Thule',
    'America/Thunder_Bay' => 'America/Thunder_Bay',
    'America/Tijuana' => 'America/Tijuana',
    'America/Toronto' => 'America/Toronto',
    'America/Tortola' => 'America/Tortola',
    'America/Vancouver' => 'America/Vancouver',
    'America/Whitehorse' => 'America/Whitehorse',
    'America/Winnipeg' => 'America/Winnipeg',
    'America/Yakutat' => 'America/Yakutat',
    'America/Yellowknife' => 'America/Yellowknife',
    'Antarctica/Casey' => 'Antarctica/Casey',
    'Antarctica/Davis' => 'Antarctica/Davis',
    'Antarctica/DumontDUrville' => 'Antarctica/DumontDUrville',
    'Antarctica/Macquarie' => 'Antarctica/Macquarie',
    'Antarctica/McMurdo' => 'Antarctica/McMurdo',
    'Antarctica/Mawson' => 'Antarctica/Mawson',
    'Antarctica/Palmer' => 'Antarctica/Palmer',
    'Antarctica/Rothera' => 'Antarctica/Rothera',
    'Antarctica/Syowa' => 'Antarctica/Syowa',
    'Antarctica/Troll' => 'Antarctica/Troll',
    'Antarctica/Vostok' => 'Antarctica/Vostok',
    'Arctic/Longyearbyen' => 'Arctic/Longyearbyen',
    'Asia/Aden' => 'Asia/Aden',
    'Asia/Almaty' => 'Asia/Almaty',
    'Asia/Amman' => 'Asia/Amman',
    'Asia/Anadyr' => 'Asia/Anadyr',
    'Asia/Aqtau' => 'Asia/Aqtau',
    'Asia/Aqtobe' => 'Asia/Aqtobe',
    'Asia/Ashgabat' => 'Asia/Ashgabat',
    'Asia/Atyrau' => 'Asia/Atyrau',
    'Asia/Baghdad' => 'Asia/Baghdad',
    'Asia/Bahrain' => 'Asia/Bahrain',
    'Asia/Baku' => 'Asia/Baku',
    'Asia/Bangkok' => 'Asia/Bangkok',
    'Asia/Barnaul' => 'Asia/Barnaul',
    'Asia/Beirut' => 'Asia/Beirut',
    'Asia/Bishkek' => 'Asia/Bishkek',
    'Asia/Brunei' => 'Asia/Brunei',
    'Asia/Chita' => 'Asia/Chita',
    'Asia/Choibalsan' => 'Asia/Choibalsan',
    'Asia/Colombo' => 'Asia/Colombo',
    'Asia/Damascus' => 'Asia/Damascus',
    'Asia/Dhaka' => 'Asia/Dhaka',
    'Asia/Dili' => 'Asia/Dili',
    'Asia/Dubai' => 'Asia/Dubai',
    'Asia/Dushanbe' => 'Asia/Dushanbe',
    'Asia/Famagusta' => 'Asia/Famagusta',
    'Asia/Gaza' => 'Asia/Gaza',
    'Asia/Hebron' => 'Asia/Hebron',
    'Asia/Ho_Chi_Minh' => 'Asia/Ho_Chi_Minh',
    'Asia/Hong_Kong' => 'Asia/Hong_Kong',
    'Asia/Hovd' => 'Asia/Hovd',
    'Asia/Irkutsk' => 'Asia/Irkutsk',
    'Asia/Jakarta' => 'Asia/Jakarta',
    'Asia/Jayapura' => 'Asia/Jayapura',
    'Asia/Jerusalem' => 'Asia/Jerusalem',
    'Asia/Kabul' => 'Asia/Kabul',
    'Asia/Kamchatka' => 'Asia/Kamchatka',
    'Asia/Karachi' => 'Asia/Karachi',
    'Asia/Kathmandu' => 'Asia/Kathmandu',
    'Asia/Khandyga' => 'Asia/Khandyga',
    'Asia/Kolkata' => 'Asia/Kolkata',
    'Asia/Krasnoyarsk' => 'Asia/Krasnoyarsk',
    'Asia/Kuala_Lumpur' => 'Asia/Kuala_Lumpur',
    'Asia/Kuching' => 'Asia/Kuching',
    'Asia/Kuwait' => 'Asia/Kuwait',
    'Asia/Macau' => 'Asia/Macau',
    'Asia/Magadan' => 'Asia/Magadan',
    'Asia/Makassar' => 'Asia/Makassar',
    'Asia/Manila' => 'Asia/Manila',
    'Asia/Muscat' => 'Asia/Muscat',
    'Asia/Nicosia' => 'Asia/Nicosia',
    'Asia/Novokuznetsk' => 'Asia/Novokuznetsk',
    'Asia/Novosibirsk' => 'Asia/Novosibirsk',
    'Asia/Omsk' => 'Asia/Omsk',
    'Asia/Oral' => 'Asia/Oral',
    'Asia/Phnom_Penh' => 'Asia/Phnom_Penh',
    'Asia/Pontianak' => 'Asia/Pontianak',
    'Asia/Pyongyang' => 'Asia/Pyongyang',
    'Asia/Qatar' => 'Asia/Qatar',
    'Asia/Qostanay' => 'Asia/Qostanay',
    'Asia/Qyzylorda' => 'Asia/Qyzylorda',
    'Asia/Riyadh' => 'Asia/Riyadh',
    'Asia/Sakhalin' => 'Asia/Sakhalin',
    'Asia/Samarkand' => 'Asia/Samarkand',
    'Asia/Seoul' => 'Asia/Seoul',
    'Asia/Shanghai' => 'Asia/Shanghai',
    'Asia/Singapore' => 'Asia/Singapore',
    'Asia/Srednekolymsk' => 'Asia/Srednekolymsk',
    'Asia/Taipei' => 'Asia/Taipei',
    'Asia/Tashkent' => 'Asia/Tashkent',
    'Asia/Tbilisi' => 'Asia/Tbilisi',
    'Asia/Tehran' => 'Asia/Tehran',
    'Asia/Thimphu' => 'Asia/Thimphu',
    'Asia/Tokyo' => 'Asia/Tokyo',
    'Asia/Tomsk' => 'Asia/Tomsk',
    'Asia/Ulaanbaatar' => 'Asia/Ulaanbaatar',
    'Asia/Urumqi' => 'Asia/Urumqi',
    'Asia/Ust-Nera' => 'Asia/Ust-Nera',
    'Asia/Vientiane' => 'Asia/Vientiane',
    'Asia/Vladivostok' => 'Asia/Vladivostok',
    'Asia/Yakutsk' => 'Asia/Yakutsk',
    'Asia/Yangon' => 'Asia/Yangon',
    'Asia/Yekaterinburg' => 'Asia/Yekaterinburg',
    'Asia/Yerevan' => 'Asia/Yerevan',
    'Atlantic/Azores' => 'Atlantic/Azores',
    'Atlantic/Bermuda' => 'Atlantic/Bermuda',
    'Atlantic/Canary' => 'Atlantic/Canary',
    'Atlantic/Cape_Verde' => 'Atlantic/Cape_Verde',
    'Atlantic/Faroe' => 'Atlantic/Faroe',
    'Atlantic/Madeira' => 'Atlantic/Madeira',
    'Atlantic/Reykjavik' => 'Atlantic/Reykjavik',
    'Atlantic/South_Georgia' => 'Atlantic/South_Georgia',
    'Atlantic/St_Helena' => 'Atlantic/St_Helena',
    'Atlantic/Stanley' => 'Atlantic/Stanley',
    'Australia/Adelaide' => 'Australia/Adelaide',
    'Australia/Brisbane' => 'Australia/Brisbane',
    'Australia/Broken_Hill' => 'Australia/Broken_Hill',
    'Australia/Currie' => 'Australia/Currie',
    'Australia/Darwin' => 'Australia/Darwin',
    'Australia/Eucla' => 'Australia/Eucla',
    'Australia/Hobart' => 'Australia/Hobart',
    'Australia/Lindeman' => 'Australia/Lindeman',
    'Australia/Lord_Howe' => 'Australia/Lord_Howe',
    'Australia/Melbourne' => 'Australia/Melbourne',
    'Australia/Perth' => 'Australia/Perth',
    'Australia/Sydney' => 'Australia/Sydney',
    'Europe/Amsterdam' => 'Europe/Amsterdam',
    'Europe/Andorra' => 'Europe/Andorra',
    'Europe/Astrakhan' => 'Europe/Astrakhan',
    'Europe/Athens' => 'Europe/Athens',
    'Europe/Belgrade' => 'Europe/Belgrade',
    'Europe/Berlin' => 'Europe/Berlin',
    'Europe/Bratislava' => 'Europe/Bratislava',
    'Europe/Brussels' => 'Europe/Brussels',
    'Europe/Bucharest' => 'Europe/Bucharest',
    'Europe/Budapest' => 'Europe/Budapest',
    'Europe/Busingen' => 'Europe/Busingen',
    'Europe/Chisinau' => 'Europe/Chisinau',
    'Europe/Copenhagen' => 'Europe/Copenhagen',
    'Europe/Dublin' => 'Europe/Dublin',
    'Europe/Gibraltar' => 'Europe/Gibraltar',
    'Europe/Guernsey' => 'Europe/Guernsey',
    'Europe/Helsinki' => 'Europe/Helsinki',
    'Europe/Isle_of_Man' => 'Europe/Isle_of_Man',
    'Europe/Istanbul' => 'Europe/Istanbul',
    'Europe/Jersey' => 'Europe/Jersey',
    'Europe/Kaliningrad' => 'Europe/Kaliningrad',
    'Europe/Kiev' => 'Europe/Kiev',
    'Europe/Kirov' => 'Europe/Kirov',
    'Europe/Lisbon' => 'Europe/Lisbon',
    'Europe/Ljubljana' => 'Europe/Ljubljana',
    'Europe/London' => 'Europe/London',
    'Europe/Luxembourg' => 'Europe/Luxembourg',
    'Europe/Madrid' => 'Europe/Madrid',
    'Europe/Malta' => 'Europe/Malta',
    'Europe/Mariehamn' => 'Europe/Mariehamn',
    'Europe/Minsk' => 'Europe/Minsk',
    'Europe/Monaco' => 'Europe/Monaco',
    'Europe/Moscow' => 'Europe/Moscow',
    'Europe/Oslo' => 'Europe/Oslo',
    'Europe/Paris' => 'Europe/Paris',
    'Europe/Podgorica' => 'Europe/Podgorica',
    'Europe/Prague' => 'Europe/Prague',
    'Europe/Riga' => 'Europe/Riga',
    'Europe/Rome' => 'Europe/Rome',
    'Europe/Samara' => 'Europe/Samara',
    'Europe/San_Marino' => 'Europe/San_Marino',
    'Europe/Sarajevo' => 'Europe/Sarajevo',
    'Europe/Saratov' => 'Europe/Saratov',
    'Europe/Simferopol' => 'Europe/Simferopol',
    'Europe/Skopje' => 'Europe/Skopje',
    'Europe/Sofia' => 'Europe/Sofia',
    'Europe/Stockholm' => 'Europe/Stockholm',
    'Europe/Tallinn' => 'Europe/Tallinn',
    'Europe/Tirane' => 'Europe/Tirane',
    'Europe/Ulyanovsk' => 'Europe/Ulyanovsk',
    'Europe/Uzhgorod' => 'Europe/Uzhgorod',
    'Europe/Vaduz' => 'Europe/Vaduz',
    'Europe/Vatican' => 'Europe/Vatican',
    'Europe/Vienna' => 'Europe/Vienna',
    'Europe/Vilnius' => 'Europe/Vilnius',
    'Europe/Volgograd' => 'Europe/Volgograd',
    'Europe/Warsaw' => 'Europe/Warsaw',
    'Europe/Zagreb' => 'Europe/Zagreb',
    'Europe/Zaporozhye' => 'Europe/Zaporozhye',
    'Europe/Zurich' => 'Europe/Zurich',
    'Indian/Antananarivo' => 'Indian/Antananarivo',
    'Indian/Chagos' => 'Indian/Chagos',
    'Indian/Christmas' => 'Indian/Christmas',
    'Indian/Cocos' => 'Indian/Cocos',
    'Indian/Comoro' => 'Indian/Comoro',
    'Indian/Kerguelen' => 'Indian/Kerguelen',
    'Indian/Mahe' => 'Indian/Mahe',
    'Indian/Maldives' => 'Indian/Maldives',
    'Indian/Mauritius' => 'Indian/Mauritius',
    'Indian/Mayotte' => 'Indian/Mayotte',
    'Indian/Reunion' => 'Indian/Reunion',
    'Pacific/Apia' => 'Pacific/Apia',
    'Pacific/Auckland' => 'Pacific/Auckland',
    'Pacific/Bougainville' => 'Pacific/Bougainville',
    'Pacific/Chatham' => 'Pacific/Chatham',
    'Pacific/Chuuk' => 'Pacific/Chuuk',
    'Pacific/Easter' => 'Pacific/Easter',
    'Pacific/Efate' => 'Pacific/Efate',
    'Pacific/Enderbury' => 'Pacific/Enderbury',
    'Pacific/Fakaofo' => 'Pacific/Fakaofo',
    'Pacific/Fiji' => 'Pacific/Fiji',
    'Pacific/Funafuti' => 'Pacific/Funafuti',
    'Pacific/Galapagos' => 'Pacific/Galapagos',
    'Pacific/Gambier' => 'Pacific/Gambier',
    'Pacific/Guadalcanal' => 'Pacific/Guadalcanal',
    'Pacific/Guam' => 'Pacific/Guam',
    'Pacific/Honolulu' => 'Pacific/Honolulu',
    'Pacific/Kiritimati' => 'Pacific/Kiritimati',
    'Pacific/Kosrae' => 'Pacific/Kosrae',
    'Pacific/Kwajalein' => 'Pacific/Kwajalein',
    'Pacific/Majuro' => 'Pacific/Majuro',
    'Pacific/Marquesas' => 'Pacific/Marquesas',
    'Pacific/Midway' => 'Pacific/Midway',
    'Pacific/Nauru' => 'Pacific/Nauru',
    'Pacific/Niue' => 'Pacific/Niue',
    'Pacific/Norfolk' => 'Pacific/Norfolk',
    'Pacific/Noumea' => 'Pacific/Noumea',
    'Pacific/Pago_Pago' => 'Pacific/Pago_Pago',
    'Pacific/Palau' => 'Pacific/Palau',
    'Pacific/Pitcairn' => 'Pacific/Pitcairn',
    'Pacific/Pohnpei' => 'Pacific/Pohnpei',
    'Pacific/Port_Moresby' => 'Pacific/Port_Moresby',
    'Pacific/Rarotonga' => 'Pacific/Rarotonga',
    'Pacific/Saipan' => 'Pacific/Saipan',
    'Pacific/Tahiti' => 'Pacific/Tahiti',
    'Pacific/Tarawa' => 'Pacific/Tarawa',
    'Pacific/Tongatapu' => 'Pacific/Tongatapu',
    'Pacific/Wake' => 'Pacific/Wake',
    'Pacific/Wallis' => 'Pacific/Wallis',
    'UTC' => 'UTC',
    'Time Format' => 'Time Format',
    'Choose your default timezone' => 'Choose your default timezone',
    'Signature' => 'Signature',
    'User signature will be append at the bottom of ticket reply box' => 'Your signature will be appended to the bottom of every ticket reply you create.',
    'Password' => 'Password',
    'Password will remain same if you are not entering something in this field' => 'Password not changed!',
    'Confirm Password' => 'Confirm Password',
    'Password must contain minimum 8 character length, at least two letters (not case sensitive), one number, one special character(space is not allowed).' => 'Password must be at least 8 characters, two letters (not case-sensitive), one number, and one special character (space is not allowed).',
    'Save Changes' => 'Save Changes',
    'SAVE CHANGES' => 'SAVE CHANGES',
    'CREATE TICKET' => 'CREATE TICKET',
    'Customer full name' => 'Customer full name',
    'Customer email address' => 'Customer email address',
    'Select Type' => 'Select Type',
    'Support' => 'Support',
    'Choose ticket type' => 'Choose ticket type',
    'Ticket subject' => 'Ticket subject',
    'Message' => 'Message',
    'Query Message' => 'Query Message',
    'Add Attachment' => 'Add Attachment',
    'This field is mandatory' => 'This field is mandatory',
    'General' => 'General',
    'Designation' => 'Designation',
    'Contant Number' => 'Content Number',
    'User signature will be append in the bottom of ticket reply box' => 'Your signature will be appended to the bottom of every ticket reply you create.',
    'Account Status' => 'Account Status',
    'Account is Active' => 'Account is Active',
    'Assigning group(s) to user to view tickets regardless assignment.' => 'Add user to group to view tickets regardless of owner.',
    'Default' => 'Default',
    'Select All' => 'Select All',
    'Remove All' => 'Remove All',
    'Assigning team(s) to user to view tickets regardless assignment.' => 'Add user to team to view tickets regardless of owner.',
    'No Team added !' => 'No Team added!',
    'Permission' => 'Permission',
    'Role' => 'Role',
    'Administrator' => 'Administrator',
    'Select agent role' => 'Select agent role',
    'Add Customer' => 'Add Customer',
    'Action' => 'Action',
    'Account Owner' => 'Account Owner',
    'Active' => 'Active',
    'Edit' => 'Edit',
    'Delete' => 'Delete',
    'Disabled' => 'Disabled',
    'New Group' => 'New Group',
    'Default Privileges' => 'Default Privileges',
    'New Privileges' => 'New Privileges',
    'NEW PRIVILEGE' => 'NEW PRIVILEGE',
    'New Privilege' => 'New Privilege',
    'New Team' => 'New Team',
    'No Record Found' => 'No Record Found',
    'Order Synchronization' => 'Order Synchronization',
    'Easily integrate different ecommerce platforms with your helpdesk which can then be later used to swiftly integrate ecommerce order details with your support tickets.' => 'Easily integrate different eCommerce platforms with your helpdesk to show order details within support tickets.',
    'BigCommerce' => 'BigCommerce',
    'No channels have been added.' => 'No channels have been added.',
    'Add BigCommerce Store' => 'Add BigCommerce Store',
    'ADD BIGCOMMERCE STORE' => 'ADD BIGCOMMERCE STORE',
    'Mangento' => 'Mangento',
    'Add Magento Store' => 'Add Magento Store',
    'OpenCart' => 'OpenCart',
    'Add OpenCart Store' => 'Add OpenCart Store',
    'ADD OPENCART STORE' => 'ADD OPENCART STORE',
    'Shopify' => 'Shopify',
    'Add Shopify Store' => 'Add Shopify Store',
    'ADD SHOPIFY STORE' => 'ADD SHOPIFY STORE',
    'Integrate a new BigCommerce store' => 'Integrate a new BigCommerce store',
    'Your BigCommerce Store Name' => 'Your BigCommerce Store Name',
    'Your BigCommerce Store Hash' => 'Your BigCommerce Store Hash',
    'Your BigCommerce Api Token' => 'Your BigCommerce Api Token',
    'Your BigCommerce Api Client ID' => 'Your BigCommerce Api Client ID',
    'Enable Channel' => 'Enable Channel',
    'Add Store' => 'Add Store',
    'ADD STORE' => 'ADD STORE',
    'Integrate a new Magento store' => 'Integrate a new Magento store',
    'Your Magento Api Username' => 'Your Magento Api Username',
    'Your Magento Api Password' => 'Your Magento Api Password',
    'Integrate a new OpenCart store' => 'Integrate a new OpenCart store',
    'Your OpenCart Api Key' => 'Your OpenCart Api Key',
    'Your Shopify Store Name' => 'Your Shopify Store Name',
    'Your Shopify Api Key' => 'Your Shopify Api Key',
    'Your Shopify Api Password' => 'Your Shopify Api Password',
    'Easily embed custom form to help generate helpdesk tickets.' => 'Easily embed custom forms for creating helpdesk tickets.',
    'Form-Builder' => 'Form-Builder',
    'Add Formbuilder' => 'Add Formbuilder',
    'ADD FORMBUILDER' => 'ADD FORMBUILDER',
    'No FormBuilder have been added.' => 'No FormBuilder was added.',
    'Create a New Custom Form Below' => 'Create a New Custom Form Below',
    'Form Name' => 'Form Name',
    'It will be shown in the list of created forms' => 'Displayed in the list of created forms',
    'MANDATORY FIELDS' => 'MANDATORY FIELDS',
    'These fields will be visible in form and cant be edited' => 'These fields will be visible in this form and can\'t be edited',
    'Reply' => 'Reply',
    'OPTIONAL FIELDS' => 'OPTIONAL FIELDS',
    'Select These Fields to Add in your Form' => 'Select fields to add',
    'GDPR' => 'GDPR',
    'Order' => 'Order',
    'Categorybuilder' => 'Categorybuilder',
    'File' => 'File',
    'Add Form' => 'Add Form',
    'ADD FORM' => 'ADD FORM',
    'UPDATE FORM' => 'UPDATE FORM',
    'Update Form' => 'Update Form',
    'Embed' => 'Embed',
    'EMBED' => 'EMBED',
    'EMBED FORMBUILDER' => 'EMBED FORMBUILDER',
    'Embed Formbuilder' => 'Embed Formbuilder',
    'Visit' => 'Visit',
    'VISIT' => 'VISIT',
    'Code' => 'Code',
    'Total Ticket(s)' => 'Total Ticket(s)',
    'Ticket Count' => 'Ticket Count',
    'SwiftMailer Configurations' => 'SwiftMailer Configurations',
    'No swiftmailer configurations found' => 'No SwiftMailer configurations found',
    'CREATE CONFIGURATION' => 'CREATE CONFIGURATION',
    'Add configuration' => 'Add configuration',
    'Update configuration' => 'Update configuration',
    'Mailer ID' => 'Mailer ID',
    'Mailer ID - Leave blank to automatically create id' => 'Mailer ID - Leave blank to automatically create id',
    'Transport Type' => 'Transport Type',
    'SMTP' => 'SMTP',
    'Enable Delivery' => 'Enable Delivery',
    'Server' => 'Server',
    'Port' => 'Port',
    'Encryption Mode' => 'Encryption Mode',
    'ssl' => 'ssl',
    'tsl' => 'tsl',
    'None' => 'None',
    'Authentication Mode' => 'Authentication Mode',
    'login' => 'login',
    'Plain' => 'Plain',
    'CRAM-MD5' => 'CRAM-MD5',
    'Sender Address' => 'Sender Address',
    'Delivery Address' => 'Delivery Address',
    'Block Spam' => 'Block Spam',
    'Black list' => 'Black list',
    'Comma (,) separated values (Eg. support@example.com, @example.com, 68.98.31.226)' => 'Comma separated values (Eg. support@example.com, @example.com, 68.98.31.226)',
    'White list' => 'White list',
    'Mailbox Settings' => 'Mailbox Settings',
    'No mailbox configurations found' => 'No mailbox configurations found',
    'NEW MAILBOX' => 'NEW MAILBOX',
    'New Mailbox' => 'New Mailbox',
    'Update Mailbox' => 'Update Mailbox',
    'Add Mailbox' => 'Add Mailbox',
    'Mailbox ID - Leave blank to automatically create id' => 'Mailbox ID - Leave blank to automatically create id',
    'Mailbox Name' => 'Mailbox Name',
    'Enable Mailbox' => 'Enable Mailbox',
    'Incoming Mail (IMAP) Server' => 'Incoming Mail (IMAP) Server',
    'Configure your imap settings which will be used to fetch emails from your mailbox.' => 'Configure your imap settings in order to fetch new mail from your inbox.',
    'Transport' => 'Transport',
    'IMAP' => 'IMAP',
    'Gmail' => 'Gmail',
    'Yahoo' => 'Yahoo',
    'Host' => 'Host',
    'IMAP Host' => 'IMAP Host',
    'Email address' => 'Email address',
    'Associated Password' => 'Associated Password',
    'Outgoing Mail (SMTP) Server' => 'Outgoing Mail (SMTP) Server',
    'Select a valid Swift Mailer configuration which will be used to send emails through your mailbox.' => 'Select the SwiftMailer config to use for sending emails through your account.',
    'Swift Mailer ID' => 'Swift Mailer ID',
    'None Selected' => 'None Selected',
    'Create Mailbox' => 'Create Mailbox',
    'CREATE MAILBOX' => 'CREATE MAILBOX',
    'New Template' => 'New Template',
    'NEW TEMPLATE' => 'NEW TEMPLATE',
    'Customer Forgot Password' => 'Customer Forgot Password',
    'Customer Account Created' => 'Customer Account Created',
    'Ticket generated success mail to customer' => 'Ticket successfully generated and sent to customer',
    'Customer Reply To The Agent' => 'Customer reply',
    'Ticket Assign' => 'Ticket Assign',
    'Agent Forgot Password' => 'Agent Forgot Password',
    'Agent Account Created' => 'Agent Account Created',
    'Ticket generated by customer' => 'Ticket generated by customer',
    'Agent Reply To The Customers ticket' => 'Agent reply',
    'Email template name' => 'Email template name',
    'Email template subject' => 'Email template subject',
    'Template For' => 'Template For',
    'Nothing Selected' => 'Nothing Selected',
    'email template will be used for work related with selected option' => 'email template will be used for selected option',
    'Email template body' => 'Email template body',
    'Body' => 'Body',
    'placeholders' => 'placeholders',
    'Ticket Subject' => 'Ticket Subject',
    'Ticket Message' => 'Ticket Message',
    'Ticket Attachments' => 'Ticket Attachments',
    'Ticket Tags' => 'Ticket Tags',
    'Ticket Source' => 'Ticket Source',
    'Ticket Status' => 'Ticket Status',
    'Ticket Priority' => 'Ticket Priority',
    'Ticket Group' => 'Ticket Group',
    'Ticket Team' => 'Ticket Team',
    'Ticket Thread Message' => 'Ticket Thread Message',
    'Ticket Customer Name' => 'Ticket Customer Name',
    'Ticket Customer Email' => 'Ticket Customer Email',
    'Ticket Agent Name' => 'Ticket Agent Name',
    'Ticket Agent Email' => 'Ticket Agent Email',
    'Ticket Agent Link' => 'Ticket Agent Link',
    'Ticket Customer Link' => 'Ticket Customer Link',
    'Last Collaborator Name' => 'Last Collaborator Name',
    'Last Collaborator Email' => 'Last Collaborator Email',
    'Agent/ Customer Name' => 'Agent/ Customer Name',
    'Account Validation Link' => 'Account Validation Link',
    'Password Forgot Link' => 'Password Forgot Link',
    'Company Name' => 'Company Name',
    'Company Logo' => 'Company Logo',
    'Company URL' => 'Company URL',
    'Swiftmailer id (Select from drop down)' => 'Swiftmailer id (Select from drop down)',
    'PROCEED' => 'PROCEED',
    'Proceed' => 'Proceed',
    'Theme Color' => 'Theme Color',
    'Customer Created' => 'Customer Created',
    'Agent Created' => 'Agent Created',
    'Ticket Created' => 'Ticket Created',
    'Agent Replied on Ticket' => 'Agent replied to ticket',
    'Customer Replied on Ticket' => 'Customer replied to ticket',
    'Workflow Status' => 'Workflow status',
    'Workflow is Active' => 'Workflow is active',
    'Events' => 'Events',
    'An event automatically triggers to check conditions and perform a respective pre-defined set of actions' => 'An event automatically triggers to check conditions and perform a set of pre-defined actions',
    'Select an Event' => 'Select an Event',
    'Add More' => 'Add More',
    'Conditions' => 'Conditions',
    'Conditions are set of rules which checks for specific scenarios and are triggered on specific occasions' => 'Conditions are sets of rules which check for specific scenarios.',
    'Subject or Description' => 'Subject or description',
    'Actions' => 'Actions',
    'An action not only reduces the workload but also makes it quite easier for ticket automation' => 'Actions help you automate tickets',
    'Select an Action' => 'Select an action',
    'Add Note' => 'Add note',
    'Mail to agent' => 'Mail to agent',
    'Mail to customer' => 'Mail to customer',
    'Mail to group' => 'Mail to group',
    'Mail to last collaborator' => 'Mail to last collaborator',
    'Mail to team' => 'Mail to team',
    'Mark Spam' => 'Mark spam',
    'Assign to agent' => 'Assign to agent',
    'Assign to group' => 'Assign to group',
    'Set Priority As' => 'Set Priority As',
    'Set Status As' => 'Set Status As',
    'Set Tag As' => 'Set Tag As',
    'Set Label As' => 'Set Label As',
    'Assign to team' => 'Assign to team',
    'Set Type As' => 'Set Type As',
    'Add Workflow' => 'Add Workflow',
    'ADD WORKFLOW' => 'ADD WORKFLOW',
    'Ticket Type code' => 'Ticket Type code',
    'Ticket Type description' => 'Ticket Type description',
    'Type Status' => 'Type Status',
    'Type is Active' => 'Type is Active',
    'Add Save Reply' => 'Add Save Reply',
    'Saved reply name' => 'Saved reply name',
    'Share saved reply with user(s) in these group(s)' => 'Share saved reply with user(s) in these group(s)',
    'Share saved reply with user(s) in these teams(s)' => 'Share saved reply with user(s) in these teams(s)',
    'Saved reply Body' => 'Saved reply body',
    'New Prepared Response' => 'New Prepared Response',
    'Prepared Response Status' => 'Prepared Response Status',
    'Prepared Response is Active' => 'Prepared Response is Active',
    'Share prepared response with user(s) in these group(s)' => 'Share prepared response with user(s) in these group(s)',
    'Share prepared response with user(s) in these teams(s)' => 'Share prepared response with user(s) in these teams(s)',
    'ADD PREPARED RESPONSE' => 'ADD PREPARED RESPONSE',
    'Add Prepared Response' => 'Add Prepared Response',
    'Folder Name is shown upfront at Knowledge Base' => 'The folder name to show in the knowledge base',
    'A small text about the folder helps user to navigate more easily' => 'A bit more info about this folder',
    'Publish' => 'Publish',
    'Choose appropriate status' => 'Choose appropriate status',
    'Folder Image' => 'Folder Image',
    'An image is worth a thousands words and makes folder more accessible' => 'Help users identify the proper folder with a recognizable image.',
    'Add Category' => 'Add Category',
    'Category Name is shown upfront at Knowledge Base' => 'The category name to show in the knowledge base',
    'A small text about the category helps user to navigate more easily' => 'A bit more info about this category',
    'Using Category Order, you can decide which category should display first' => 'Using Category Order, you can decide which category should display first',
    'Sorting' => 'Sorting',
    'Ascending Order (A-Z)' => 'Ascending Order (A-Z)',
    'Descending Order (Z-A)' => 'Descending Order (Z-A)',
    'Based on Popularity' => 'Based on Popularity',
    'Article of this category will display according to selected option' => 'Articles in this category will display depending on selected option',
    'Article' => 'Article',
    'Title' => 'Title',
    'View' => 'View',
    'Make as Starred' => 'Mark as Starred',
    'Yes' => 'Yes',
    'No' => 'No',
    'Stared' => 'Stared',
    'Revisions' => 'Revisions',
    'Related Articles' => 'Related Articles',
    'Delete Article' => 'Delete Article',
    'Content' => 'Content',
    'Slug' => 'Slug',
    'Slug is the url identity of this article.' => 'The URL for this article',
    'Meta Title' => 'Meta Title',
    'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. A pages title tag and meta description are usually shown whenever that page appears in search engine results' => 'Title tags and meta descriptions are bits of HTML code in the header of a web page. They help search engines understand the content on a page. The title tag and meta description are usually shown in search engine results for the page.',
    'Meta Keywords' => 'Meta Keywords',
    'Meta Description' => 'Meta Description',
    'Description' => 'Description',
    'Team Status' => 'Team Status',
    'Team is Active' => 'Team is Active',
    'Edit Privilege' => 'Edit Privilege',
    'Can create ticket' => 'Can create ticket',
    'Can edit ticket' => 'Can edit ticket',
    'Can delete ticket' => 'Can delete ticket',
    'Can restore trashed ticket' => 'Can restore trashed ticket',
    'Can assign ticket' => 'Can assign ticket',
    'Can assign ticket group' => 'Can assign ticket group',
    'Can update ticket status' => 'Can update ticket status',
    'Can update ticket priority' => 'Can update ticket priority',
    'Can update ticket type' => 'Can update ticket type',
    'Can add internal notes to ticket' => 'Can add internal notes to ticket',
    'Can edit thread/notes' => 'Can edit thread/notes',
    'Can lock/unlock thread' => 'Can lock/unlock thread',
    'Can add collaborator to ticket' => 'Can add collaborator to ticket',
    'Can delete collaborator from ticket' => 'Can delete collaborator from ticket',
    'Can delete thread/notes' => 'Can delete thread/notes',
    'Can apply prepared response on ticket' => 'Can apply prepared response on ticket',
    'Can add ticket tags' => 'Can add ticket tags',
    'Can delete ticket tags' => 'Can delete ticket tags',
    'Can kick other ticket users' => 'Can kick other ticket users',
    'Can manage email templates' => 'Can manage email templates',
    'Can manage groups' => 'Can manage groups',
    'Can manage Sub-Groups/ Teams' => 'Can manage Sub-Groups/ Teams',
    'Can manage agents' => 'Can manage agents',
    'Can manage agent privileges' => 'Can manage agent privileges',
    'Can manage ticket types' => 'Can manage ticket types',
    'Can manage ticket custom fields' => 'Can manage ticket custom fields',
    'Can manage customers' => 'Can manage customers',
    'Can manage Prepared Responses' => 'Can manage Prepared Responses',
    'Can manage Automatic workflow' => 'Can manage Automatic workflow',
    'Can manage tags' => 'Can manage tags',
    'Can manage knowledgebase' => 'Can manage knowledgebase',
    'Can manage Groups Saved Reply' => 'Can manage Groups Saved Reply',
    'Add Privilege' => 'Add Privilege',
    'Choose set of privileges which will be available to the agent.' => 'Choose set of privileges which will be available to the agent.',
    'Advanced' => 'Advanced',
    'Privilege Name must have characters only' => 'Privilege Name must have characters only',
    'Maximum character length is 50' => 'Maximum character length is 50',
    'Open Tickets' => 'Open Tickets',
    'New Customer' => 'New Customer',
    'New Agent' => 'New Agent',
    'Total Article(s)' => 'Total Article(s)',
    'Please specify a valid email address' => 'Please specify a valid email address',
    'Please enter the password associated with your email address' => 'Please enter the password associated with your email address',
    'Please enter your server host address' => 'Please enter your server host address',
    'Please specify a port number to connect with your mail server' => 'Please specify the port number for your mail server',
    'Success ! Branding details saved successfully.' => 'Success! Branding details saved successfully.',
    'Success ! Time details saved successfully.' => 'Success! Time details saved successfully.',
    'Spam setting saved successfully.' => 'Spam setting saved successfully.',
    'Please specify a valid name for your mailbox.' => 'Please specify a valid name for your mailbox.',
    'Please select a valid swift-mailer configuration.' => 'Please select a valid swift-mailer configuration.',
    'Please specify a valid host address.' => 'Please specify a valid host address.',
    'Please specify a valid email address.' => 'Please specify a valid email address.',
    'Please enter the associated account password.' => 'Please enter the associated account password.',
    'New Saved Reply' => 'New Saved Reply',
    'New Category' => 'New Category',
    'Folder' => 'Folder',
    'Category' => 'Category',
    'Created' => 'Created',
    'All Articles' => 'All Articles',
    'Viewed' => 'Viewed',
    'New Article' => 'New Article',
    'Thank you for your feedback!' => 'Thank you for your feedback!',
    'Was this article helpful?' => 'Was this article helpful?',
    'Helpdesk' => 'Helpdesk',
    'Support Center' => 'Support Center',
    'Mailboxes' => 'Mailboxes',
    'By' => 'By',
    'Search Tickets' => 'Search Tickets',
    'Customer Information' => 'Customer Information',
    'Total Replies' => 'Total Replies',
    'Filter With' => 'Filter With',
    'Type email to add' => 'Type email to add',
    'Collaborators' => 'Collaborators',
    'Labels' => 'Labels',
    'Group' => 'Group',
    'group' => 'group',
    'Contact Team' => 'Contact Team',
    'Stay on ticket' => 'Stay on ticket',
    'Redirect to list' => 'Redirect to list',
    'Nothing interesting here...' => 'Nothing interesting here',
    'Previous Ticket' => 'Previous Ticket',
    'Next Ticket' => 'Next Ticket',
    'Forward' => 'Forward',
    'Note' => 'Note',
    'Write a reply' => 'Write a reply',
    'Created Ticket' => 'Created Ticket',
    'All Threads' => 'All Threads',
    'Forwards' => 'Forwards',
    'Notes' => 'Notes',
    'Pinned' => 'Pinned',
    'Edit Ticket' => 'Edit Ticket',
    'Print Ticket' => 'Print Ticket',
    'Mark as Spam' => 'Mark as Spam',
    'Mark as Closed' => 'Mark as Closed',
    'Delete Ticket' => 'Delete Ticket',
    'View order details from different eCommerce channels' => 'View order details from different eCommerce channels',
    'ECOMMERCE CHANNELS' => 'ECOMMERCE CHANNELS',
    'Select channel' => 'Select channel',
    'Order Id' => 'Order Id',
    'Fetch Order' => 'Fetch Order',
    'No orders have been integrated to this ticket yet.' => 'No orders have been associated with this ticket yet.',
    'Enter your credentials below to gain access to your helpdesk account.' => 'Enter your credentials below to sign in',
    'Keep me logged in' => 'Keep me logged in',
    'Forgot Password?' => 'Forgot Password?',
    'Log in to your' => 'Log in to your',
    'Sign In' => 'Sign In',
    'Edit Customer' => 'Edit Customer',
    'Update' => 'Update',
    'Discard' => 'Discard',
    'Cancel' => 'Cancel',
    'Not Assigned' => 'Not Assigned',
    'Submit' => 'Submit',
    'Submit And Open' => 'Submit And Open',
    'Submit And Pending' => 'Submit And Pending',
    'Submit And Answered' => 'Submit And Answered',
    'Submit And Resolved' => 'Submit And Resolved',
    'Submit And Closed' => 'Submit And Closed',
    'Choose a Color' => 'Choose a Color',
    'Create' => 'Create',
    'Edit Label' => 'Edit Label',
    'Add Label' => 'Add Label',
    'To' => 'To',
    'Ticket' => 'Ticket',
    'Your browser does not support JavaScript or You disabled JavaScript, Please enable those !' => 'Your browser does not support Javascript or Javascript is disabled. Please correct this!',
    'Confirm Action' => 'Confirm Action',
    'Confirm' => 'Confirm',
    'No result found' => 'No result found',
    'ticket delivery status' => 'ticket delivery status',
    'Warning! Select valid image file.' => 'Warning! Select valid image file.',
    'Error' => 'Error',
    'Save' => 'Save',
    'SEO' => 'SEO',
    'Edit Saved Filter' => 'Edit Saved Filter',
    'Type atleast 2 letters' => 'Type at least 2 letters',
    'Remove Label' => 'Remove Label',
    'New Saved Filter' => 'New Saved Filter',
    'Is Default' => 'Is Default',
    'Remove Saved Filter' => 'Remove Saved Filter',
    'Ticket Info' => 'Ticket Info',
    'Last Replied Agent' => 'Last Replied Agent',
    'created Ticket' => 'created Ticket',
    'Uploaded Files' => 'Uploaded Files',
    'Download (as .zip)' => 'Download ( as .zip)',
    'made last reply' => 'last reply',
    'N/A' => 'N/A',
    'Unassigned' => 'Unassigned',
    'Label' => 'Label',
    'Assigned to me' => 'Assigned to me',
    'Search Query' => 'Search Query',
    'Searching' => 'Searching',
    'Saved Filter' => 'Saved Filter',
    'No Label Created' => 'No Label Created',
    'Label with same name already exist.' => 'Label with same name already exists',
    'Create New' => 'Create New',
    'Mail status' => 'Mail status',
    'replied' => 'replied',
    'added note' => 'added note',
    'forwarded' => 'forwarded',
    'TO' => 'TO',
    'CC' => 'CC',
    'BCC' => 'BCC',
    'Locked' => 'Locked',
    'Edit Thread' => 'Edit Thread',
    'Delete Thread' => 'Delete Thread',
    'Unpin Thread' => 'Unpin Thread',
    'Pin Thread' => 'Pin Thread',
    'Unlock Thread' => 'Unlock Thread',
    'Lock Thread' => 'Lock Thread',
    'Translate Thread' => 'Translate Thread',
    'Language' => 'Language',
    'English' => 'English',
    'French' => 'French',
    'Italian' => 'Italian',
    'Arabic' => 'Arabic',
    'German' => 'German',
    'Spanish' => 'Spanish',
    'Turkish' => 'Turkish',
    'Danish' => 'Danish',
    'Chinese' => 'Chinese',
    'Polish' => 'Polish',
    'System' => 'System',
    'Open in Files' => 'Open in Files',
    'Email address is invalid' => 'Email address is invalid',
    'Tag with same name already exist' => 'Tag with this name already exist',
    'Text length should be less than 20 charactors' => 'Must be less than 20 characters',
    'Label with same name already exist' => 'Label with same name already exist',
    'Agent Name' => 'Agent Name',
    'Agent Email' => 'Agent Email',
    'open' => 'open',
    'Currently active agents on ticket' => 'Currently active agents on ticket',
    'Edit Customer Information' => 'Edit Customer Information',
    'Restore' => 'Restore',
    'Delete Forever' => 'Delete Forever',
    'Add Team' => 'Add Team',
    'delete' => 'delete',
    'You didnt have any folder for current filter(s).' => 'No folders match current filter(s).',
    'Add Folder' => 'Add Folder',
    'This field must have valid characters only' => 'This field must have valid characters only',
    'Can edit task' => 'Can edit task',
    'Can create task' => 'Can create task',
    'Can delete task' => 'Can delete task',
    'Can add member to task' => 'Can add member to task',
    'Can remove member from task' => 'Can remove member from task',
    'Agent Privileges' => 'Agent Privileges',
    'Agent Privilege represents overall permissions in System.' => 'Agent privilege represents overall permissions in your helpdesk.',
    'Ticket View' => 'Ticket View',
    'User can view tickets based on selected scope.' => 'User can view tickets based on selected scope.',
    'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) he belongs to and so on' => 'If individual access then user can View assigned Ticket(s) only, If Team access then user can view all Ticket(s) in team(s) they belongs to, etc.',
    'Global Access' => 'Global Access',
    'Group Access' => 'Group Access',
    'Team Access' => 'Team Access',
    'Individual Access' => 'Individual Access',
    'This field must have characters only' => 'This field must have characters only',
    'Maximum character length is 40' => 'Maximum character length is 40',
    'This is not a valid email address' => 'This is not a valid email address',
    'Password must contains 8 Characters' => 'Password must contains 8 Characters',
    'The passwords does not match' => 'The passwords do not match',
    'Enabled' => 'Enabled',
    'Create Configuration' => 'Create Configuration',
    'Swift Mailer Settings' => 'Swift Mailer Settings',
    'Username' => 'Username',
    'Please select a swiftmailer id' => 'Please select a swiftmailer id',
    'Please enter a valid e-mail id' => 'Please enter a valid e-mail id',
    'Please enter a mailer id' => 'Please enter a mailer id',
    'Email Id' => 'Email Id',
    'Are you sure? You want to perform this action.' => 'Are you sure you want to perform this action?',
    'Reorder' => 'Reorder',
    'New Workflow' => 'New Workflow',
    'OR' => 'OR',
    'AND' => 'AND',
    'Please enter a valid name.' => 'Please enter a valid name.',
    'Please select a value.' => 'Please select a value.',
    'Please add a value.' => 'Please add a value.',
    'This field is required' => 'This field is required',
    'or' => 'or',
    'and' => 'and',
    'Select a Condition' => 'Select a Condition',
    'Loading...' => 'Loading...',
    'Select Option' => 'Select Option',
    'Inactive' => 'Inactive',
    'New Type' => 'New Type',
    'Placeholders' => 'Placeholders',
    'Ticket Link' => 'Ticket Link',
    'Id' => 'Id',
    'Preview' => 'Preview',
    'Sort Order' => 'Sort Order',
    'This field must be a number' => 'This field must be a number',
    'User' => 'User',
    'Edit Group' => 'Edit Group',
    'Group Status' => 'Group Status',
    'Group is Active' => 'Group is Active',
    'Add Group' => 'Add Group',
    'Contact number is invalid' => 'Contact number is invalid',
    'Edit Agent' => 'Edit Agent',
    'No Privilege added, Please add Privilege(s) first !' => 'No privilege added, please add privilege(s) first!',
    'Edit Email Template' => 'Edit Email Template',
    'Edit Workflow' => 'Edit Workflow',
    'Save Workflow' => 'Save Workflow',
    'Edit Ticket Type' => 'Edit Ticket Type',
    'Add Ticket Type' => 'Add Ticket Type',
    'Date Released' => '	Date Released',
    'Free' => 'Free',
    'Premium' => 'Premium',
    'Installed' => 'Installed',
    'Installed Applications' => 'Installed Applications',
    'Apps Dashboard' => 'Apps Dashboard',
    'Dashboard' => 'Dashboard',
    'Nothing Interesting here' => 'Nothing interesting here',
    'No Categories Added' => 'No Categories Added',
    'Error : Something went wrong, please try again later' => 'Error: Something went wrong, please try again later',
    'ticket' => 'ticket',
    'Add Email Template' => 'Add Email Template',
    'This field contain 100 characters only' => 'Max 100 characters',
    'This field contain characters only' => 'This field may contain characters only',
    'Name length must not be greater than 200 !!' => 'Name length must not be greater than 200!',
    'Warning! Correct all field values first!' => 'Warning! Correct all field values first!',
    'Warning ! This is not a valid request' => 'Warning! This is not a valid request',
    'Success ! Tag removed successfully.' => 'Success! Tag removed successfully.',
    'Success ! Tags Saved successfully.' => 'Success! Tags Saved successfully.',
    'Success ! Revision restored successfully.' => 'Success! Revision restored successfully.',
    'Success ! Categories updated successfully.' => 'Success! Categories updated successfully.',
    'Success ! Article Related removed successfully.' => 'Success! Related article removed successfully.',
    'Success ! Article Related is already added.' => 'Success! Related article added.',
    'Success ! Cannot add self as relative article.' => 'Success! Cannot add self as relative article.',
    'Success ! Article Related updated successfully.' => 'Success! Related article updated successfully.',
    'Success ! Articles removed successfully.' => 'Success! Articles removed successfully.',
    'Success ! Article status updated successfully.' => 'Success! Article status updated successfully.',
    'Success ! Article star updated successfully.' => 'Success! Article star updated successfully.',
    'Success! Article updated successfully' => 'Success! Article updated successfully',
    'Success ! Category sort  order updated successfully.' => 'Success! Category sort order updated successfully.',
    'Success ! Category status updated successfully.' => 'Success! Category status updated successfully.',
    'Success ! Folders updated successfully.' => 'Success! Folders updated successfully.',
    'Success ! Categories removed successfully.' => 'Success! Categories removed successfully.',
    'Success ! Category updated successfully.' => 'Success! Category updated successfully.',
    'Error ! Category is not exist.' => 'Error! Category does not exist.',
    'Warning ! Customer Login disabled by admin.' => 'Warning! Customer Login disabled by admin.',
    'This Email is not registered with us.' => 'This email is not registered with us.',
    'Your password has been updated successfully.' => 'Your password has been updated successfully.',
    'Password dont match.' => 'Password doesn\'t match.',
    'Error ! Profile image is not valid, please upload a valid format' => 'Error! Profile image is not valid, please upload a valid format',
    'Warning! Provide valid image file. (Recommened": "PNG, JPG or GIF Format).' => 'Warning! invalid image file. (Recommened": "PNG, JPG or GIF Format).',
    'Success! Folder has been added successfully.' => 'Success! Folder has been added successfully.',
    'Folder updated successfully.' => 'Folder updated successfully.',
    'Success ! Folder status updated successfully.' => 'Success! Folder status updated successfully.',
    'Error ! Folder is not exist.' => 'Error! Folder does not exist.',
    'Success ! Folder updated successfully.' => 'Success! Folder updated successfully.',
    'Error ! Folder does not exist.' => 'Error! Folder does not exist.',
    'Success ! Folder deleted successfully.' => 'Success! Folder deleted successfully.',
    'Warning ! Folder doesnt exists!' => 'Warning! Folder doesn\'t exists!',
    'Warning ! Cannot create ticket, given email is blocked by admin.' => 'Warning! Can\'t create ticket, given email is blocked by admin.',
    'Success ! Ticket has been created successfully.' => 'Success! Ticket has been created successfully.',
    'Warning ! Can not create ticket, invalid details.' => 'Warning! Can not create ticket, invalid details.',
    'Warning ! Post size can not exceed 25MB' => 'Warning! attachmment size can not exceed 25MB',
    'Create Ticket Request' => 'Create Ticket Request',
    'Success ! Reply added successfully.' => 'Success! Reply added successfully.',
    'Warning ! Reply field can not be blank.' => 'Warning! Reply field can not be blank.',
    'Success ! Rating has been successfully added.' => 'Success! Rating has been successfully added.',
    'Warning ! Invalid rating.' => 'Warning! Invalid rating.',
    'Error ! Can not add customer as a collaborator.' => 'Error! Can not add customer as a collaborator.',
    'Success ! Collaborator added successfully.' => 'Success! Collaborator added successfully.',
    'Error ! Collaborator is already added.' => 'Error! Collaborator is already added.',
    'Success ! Collaborator removed successfully.' => 'Success! Collaborator removed successfully.',
    'Error ! Invalid Collaborator.' => 'Error! Invalid Collaborator.',
    'An unexpected error occurred. Please try again later.' => 'An unexpected error occurred. Please try again later.',
    'Feedback saved successfully.' => 'Feedback saved successfully.',
    'Feedback updated successfully.' => 'Feedback updated successfully.',
    'Invalid feedback provided.' => 'Invalid feedback provided.',
    'Article not found.' => 'Article not found.',
    'You need to login to your account before can perform this action.' => 'You need to log in to your account before can perform this action.',
    'Warning! Please add valid Actions!' => 'Warning! Please add valid actions!',
    'Warning! In Free Plan you can not change Events!' => 'Warning! In free plan you can not change events!',
    'Success! Prepared Response has been updated successfully.' => 'Success! Prepared response has been updated successfully.',
    'Success! Prepared Response has been added successfully.' => 'Success! Prepared response has been added successfully.',
    'Warning  This is not a valid request' => 'Warning! This is not a valid request',
    'Use Default Colors' => 'Use Default Colors',
    'Masonry' => 'Masonry',
    'Popular Article' => 'Popular Article',
    'Manage Ticket Custom Fields' => 'Manage Ticket Custom Fields',
    'Mail status:' => 'Mail status:',
    'You dont have premission to edit this Prepared response' => 'You don\'t have premission to edit this prepared response',
    'Save Prepared Response' => 'Save prepared response',
    'Success ! Prepared response removed successfully.' => 'Success! Prepared response removed successfully.',
    'Warning! You are not allowed to perform this action.' => 'Warning! You are not allowed to perform this action.',
    'Success! Workflow has been updated successfully.' => 'Success! Workflow has been updated successfully.',
    'Success! Workflow has been added successfully.' => 'Success! Workflow has been added successfully.',
    'Success! Order has been updated successfully.' => 'Success! Order has been updated successfully.',
    'Success! Workflow has been removed successfully.' => 'Success! Workflow has been removed successfully.',
    'Mailbox successfully created.' => 'Mailbox successfully created.',
    'Mailbox successfully updated.' => 'Mailbox successfully updated.',
    'Warning ! Bad request !' => 'Warning! Bad request!',
    'Error! Given current password is incorrect.' => 'Error! Password is incorrect.',
    'Success ! Profile update successfully.' => 'Success! Profile update successfully.',
    'Error ! User with same email is already exist.' => 'Error! User with same email already exists.',
    'Success ! Agent updated successfully.' => 'Success! Agent updated successfully.',
    'Success ! Agent removed successfully.' => 'Success! Agent removed successfully.',
    'Warning ! You are allowed to remove account owners account.' => 'Warning! You are allowed to remove this account.',
    'Error ! Invalid user id.' => 'Error! Invalid user id.',
    'Success ! Filter has been saved successfully.' => 'Success! Filter has been saved successfully.',
    'Success ! Filter has been updated successfully.' => 'Success! Filter has been updated successfully.',
    'Success ! Filter has been removed successfully.' => 'Success! Filter has been removed successfully.',
    'Please check your mail for password update.' => 'Please check your inbox for a new password.',
    'This Email address is not registered with us.' => 'This email address is not registered with us.',
    'Success ! Customer saved successfully.' => 'Success! Customer saved successfully.',
    'Error ! User with same email already exist.' => 'Error! User with same email already exists.',
    'Success ! Customer information updated successfully.' => 'Success! Customer information updated successfully.',
    'Success ! Customer updated successfully.' => 'Success! Customer updated successfully.',
    'Error ! Customer with same email already exist.' => 'Error! Customer with same email already exists.',
    'unstarred Action Completed successfully' => 'unstarred action completed successfully',
    'starred Action Completed successfully' => 'starred action completed successfully',
    'Success ! Customer removed successfully.' => 'Success! Customer removed successfully.',
    'Error ! Invalid customer id.' => 'Error! Invalid customer id.',
    'Success! Template has been updated successfully.' => 'Success! Template has been updated successfully.',
    'Success! Template has been added successfully.' => 'Success! Template has been added successfully.',
    'Success! Template has been deleted successfully.' => 'Success! Template has been deleted successfully.',
    'Warning! resource not found.' => 'Warning! resource not found.',
    'Warning! You can not remove predefined email template which is being used in workflow(s).' => 'Warning! You can not remove an email template which is being used in workflow(s).',
    'Success ! Email settings are updated successfully.' => 'Success! Email settings successfully updated.',
    'Success ! Group information updated successfully.' => 'Success! Group information updated successfully.',
    'Success ! Group information saved successfully.' => 'Success! Group information saved successfully.',
    'Support Group removed successfully.' => 'Support Group removed successfully.',
    'Success ! Privilege information saved successfully.' => 'Success! Privilege information saved successfully.',
    'Privilege updated successfully.' => 'Privilege updated successfully.',
    'Support Privilege removed successfully.' => 'Support privilege removed successfully.',
    'Success! Reply has been updated successfully.' => 'Success! Reply has been updated successfully.',
    'Success! Reply has been added successfully.' => 'Success! Reply has been added successfully.',
    'Success! Saved Reply has been deleted successfully' => 'Success! Saved Reply has been deleted successfully',
    'SwiftMailer configuration updated successfully.' => 'SwiftMailer configuration updated successfully.',
    'Swiftmailer configuration removed successfully.' => 'Swiftmailer configuration removed successfully.',
    'Success ! Team information saved successfully.' => 'Success! Team information saved successfully.',
    'Success ! Team information updated successfully.' => 'Success! Team information updated successfully.',
    'Support Team removed successfully.' => 'Support Team removed successfully.',
    'Success! Reply has been added successfully' => 'Success! Reply has been added successfully',
    'Success ! Thread updated successfully.' => 'Success! Thread updated successfully.',
    'Error ! Reply field can not be blank.' => 'Error  Reply field can not be blank.',
    'Success ! Thread removed successfully.' => 'Success! Thread removed successfully.',
    'Success ! Thread locked successfully' => 'Success! Thread locked successfully',
    'Success ! Thread unlocked successfully' => 'Success! Thread unlocked successfully',
    'Success ! Thread pinned successfully' => 'Success! Thread unpinned successfully',
    'Error ! Invalid thread.' => 'Error! Invalid thread.',
    'Could not create ticket, invalid details.' => 'Could not create ticket, invalid details.',
    'Success ! Tag updated successfully.' => 'Success! Tag updated successfully.',
    'Error ! Customer can not be added as collaborator.' => 'Error! Customer can not be added as collaborator.',
    'Success ! Tag unassigned successfully.' => 'Success! Tag unassigned successfully.',
    'Success ! Tag added successfully.' => 'Success! Tag added successfully.',
    'Please enter tag name.' => 'Please enter tag name.',
    'Error ! Invalid tag.' => 'Error! Invalid tag.',
    'Success ! Type removed successfully.' => 'Success! Type removed successfully.',
    'Success ! Ticket to label removed successfully.' => 'Success! Ticket label removed successfully.',
    'Unable to retrieve support team details' => 'Unable to retrieve support team details',
    'Ticket support group updated successfully' => 'Ticket support group updated successfully',
    'Unable to retrieve status details' => 'Unable to retrieve status details',
    'Insufficient details provided.' => 'Insufficient details provided.',
    'Error! Subject field is mandatory' => 'Error! Subject field is mandatory',
    'Error! Reply field is mandatory' => 'Error! Reply field is mandatory',
    'Success ! Ticket has been updated successfully.' => 'Success! Ticket has been updated successfully.',
    'Success ! Label updated successfully.' => 'Success! Label updated successfully.',
    'Error ! Invalid label id.' => 'Error! Invalid label id.',
    'Success ! Label removed successfully.' => 'Success! Label removed successfully.',
    'Success ! Label created successfully.' => 'Success! Label created successfully.',
    'Error ! Label name can not be blank.' => 'Error! Label name can not be blank.',
    'Success ! Ticket moved to trash successfully.' => 'Success! Ticket moved to trash successfully.',
    'Success! Ticket type saved successfully.' => 'Success! Ticket type saved successfully.',
    'Success! Ticket type updated successfully.' => 'Success! Ticket type updated successfully.',
    'Error! Ticket type with same name already exist' => 'Error! Ticket type with same name already exist',
    'SAVE' => 'SAVE',
    'Howdy!' => 'Howdy!',
    'New Ticket Request' => 'New Ticket Request',
    'Ticket Requests' => 'Ticket Requests',
    'Tickets have been updated successfully' => 'Tickets have been updated successfully',
    'Please check your mail for password update' => 'Please check your inbox for a new password',
    'This email address is not registered with us' => 'This email address is not registered with us',
    'You have already update password using this link if you wish to change password again click on forget password link here from login page' => 'You have already updated your password using this link. If you wish to change your password again click on the forget password link on the login page.',
    'Your password has been successfully updated. Login using updated password' => 'Your password has been successfully updated. Please log in using your new password.',
    'Please try again, The passwords do not match' => 'Please try again, The passwords do not match',
    'Support Privilege removed successfully' => 'Support Privilege removed successfully',
    'Success! Saved Reply has been deleted successfully.' => 'Success! Saved Reply has been deleted successfully.',
    'SwiftMailer configuration created successfully.' => 'SwiftMailer configuration created successfully.',
    'No swiftmailer configurations found for mailer id:' => 'No swiftmailer configurations found for mailer id:',
    'Reply content cannot be left blank.' => 'Reply content cannot be left blank.',
    'Reply added to the ticket and forwarded successfully.' => 'Reply added to the ticket and forwarded successfully.',
    'Success ! Thread pinned successfully.' => 'Success! Thread pinned successfully.',
    'Success ! unpinned removed successfully.' => 'Success! Thread unpinned successfully.',
    'Unable to retrieve priority details' => 'Unable to retrieve priority details',
    'Ticket support team updated successfully' => 'Ticket support team updated successfully',
    'Ticket assigned to support group ' => 'Ticket assigned to support group ',
    'Mailbox configuration removed successfully.' => 'Mailbox configuration removed successfully.',
    'visit our website' => 'visit our website',
    'Cookie Usage Policy' => 'Cookie Usage Policy',
    'cookie' => 'cookie',
    'cookies' => 'cookies',
    'HELP' => 'HELP',
    'Home' => 'Home',
    'Cookie Policy' => 'Cookie Policy',
    'Prev' => 'Prev',
    'Ticket query message' => 'Ticket content',
    'Select type' => 'Select type',
    'Search KnowledgeBase' => 'Search KnowledgeBase',
    'You cant merge an account with itself.' => 'You can\'t merge an account with itself.',
    'Edit Profile' => 'Edit Profile',
    'Customer Login' => 'Customer Login',
    'Contact Us' => 'Contact Us',
    'If you have ever contacted our support previously, your account would have already been created.' => 'If you have ever contacted us previously, your account is more than likely already created.',
    'support' => 'support',
    'HelpDesk' => 'HelpDesk',
    'Enter search keyword' => 'Enter search keyword',
    'Browse via Folders' => 'Explore the knowledge base',
    'Looking for something that is queried generally? Choose a relevant folder from below to explore possible solutions' => 'Check out our knowledge base to see if your question has already been answered.',
    'Unable to find an answer?' => 'Contact Our Team',
    'Looking for anything specific article which resides in general queries? Just browse the various relevant folders and categories and then you will find the desired article.' => 'If you still can\'t find an answer to what you\'re looking for, or you have a specific question, open a new ticket and we\'d be happy to help!',
    'Popular Articles' => 'Popular Articles',
    'Here are some of the most popular articles, which helped number of users to get their queries and questions resolved.' => 'Some of the more popular articles in our knowledge base that have helped other customers.',
    'Browse via Categories' => 'Browse via Categories',
    'Looking for something specific? Choose a relevant category from below to explore possible solutions' => 'Choose a category from the list below to view articles.',
    'No Categories Found!' => 'No Categories Found!',
    'Powered by' => 'Powered by',
    'Forgot Password' => 'Forgot Password',
    'Enter your email address and we will send you an email with instructions to update your login credentials.' => 'Enter your email address and we will send you a message to update your login credentials.',
    'Send Mail' => 'Send Mail',
    'Sign In to %websitename%' => 'Sign In to %websitename%',
    'Enter your name' => 'Enter your name',
    'Enter your email' => 'Enter your email',
    'Learn more about %deliveryStatus%.' => 'Learn more about %deliveryStatus%.',
    'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.' => 'Some of our site pages utilize %cookies% and other tracking technologies. A %cookie% is a small text file that may be used, for example, to collect information about site activity. Some cookies and other technologies may serve to recall personal information previously indicated by a site user. You may block cookies, or delete existing cookies, by adjusting the appropriate setting on your browser. Please consult the %help% menu of your browser to learn how to do this. If you block or delete %cookies% you may find the usefulness of our site to be impaired.',
    'To know more about how our privacy policy works, please %websiteLink%.' => 'To know more about our privacy policy, please visit %websiteLink%.',
    'This field contain maximum 40 charectures.' => 'This field contain maximum 40 charectures.',
    'This field contain maximum 50 charectures.' => 'This field contain maximum 50 charectures.',
    'Time' => 'Time',
    'Links' => 'Links',
    'Broadcast Message' => 'Broadcast Message',
    'Wide Logo' => 'Wide Logo',
    'Upload an Image (200px x 48px) in</br> PNG or JPG Format' => 'Upload an Image (200px x 48px) in</br> PNG or JPG Format',
    'It will be shown as Logo on Knowledgebase and Helpdesk' => 'Your knowledge base / helpdesk logo',
    'Website Status' => 'Website Status',
    'Enable front end website and knowledgebase for customer(s)' => 'Enable front end website and knowledgebase for customer(s)',
    'Brand Color' => 'Brand Color',
    'Page Background Color' => 'Page Background Color',
    'Header Background Color' => 'Header Background Color',
    'Banner Background Color' => 'Banner Background Color',
    'Page Link Color' => 'Page Link Color',
    'Page Link Hover Color' => 'Page Link Hover Color',
    'Article Text Color' => 'Article Text Color',
    'Tag Line' => 'Tag Line',
    'Hi! how can we help?' => 'Hi! how can we help?',
    'Layout' => 'Layout',
    'Ticket Create Option' => 'Ticket Create Option',
    'Login Required To Create Tickets' => 'Login required To create tickets',
    'Remove Customer Login/Signin Button' => 'Remove customer log in / sign in button',
    'Disable Customer Login' => 'Disable Customer Login',
    'Meta Description (Recommended)' => 'Meta Description (Recommended)',
    'Meta Keywords (Recommended)' => 'Meta Keywords (Recommended)',
    'Header Link' => 'Header Link',
    'URL (with http":/"/ or https":/"/)' => 'URL (with http":/"/ or https":/"/)',
    'Footer Link' => 'Footer Link',
    'Custom CSS (Optional)' => 'Custom CSS (Optional)',
    'It will be add to the frontend knowledgebase only' => 'Displayed only in front end knowledge base',
    'Custom Javascript (Optional)' => 'Custom Javascript (Optional)',
    'Broadcast message content to show on helpdesk' => 'Broadcast message content to show on helpdesk',
    'From' => 'From',
    'Time duration between which message will be displayed(if applicable)' => 'How long should the message be displayed?',
    'Broadcasting Status' => 'Broadcasting Status',
    'Broadcasting is Active' => 'Broadcasting is Active',
    'Choose a default company timezone' => 'Choose a default companys timezone',
    'Date Time Format' => 'Date Time Format',
    'Choose a format to convert date to specified date time format' => 'Choose a format to convert date to specified date time format',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'File size must not be greater than 200KB !!' => 'File size must not be greater than 200KB!',
    'Please upload valid Image file (Only JPEG, JPG, PNG allowed)!!' => 'Please upload a valid omage file (JPEG or PNG)!',
    'Provide a valid url(with protocol)' => 'Provide a valid url (with protocol)',
    'ticket.message.placeHolders.info' => 'ticket.message.placeHolders.info',
    'ticket.attachments.placeHolders.info' => '	ticket.attachments.placeHolders.info',
    'ticket.threadMessage.placeHolders.info' => 'ticket.threadMessage.placeHolders.info',
    'ticket.tags.placeHolders.info' => 'ticket.tags.placeHolders.info',
    'ticket.source.placeHolders.info' => 'ticket.source.placeHolders.info',
    'ticket.collaborator.name.placeHolders.info' => 'ticket.collaborator.name.placeHolders.info',
    'ticket.collaborator.email.placeHolders.info' => 'ticket.collaborator.email.placeHolders.info',
    'user.name.info' => 'user.name.info',
    'user.email.info' => 'user.email.info',
    'user.account.validate.link.info' => 'user.account.validate.link.info',
    'user.password.forgot.link.info' => 'user.password.forgot.link.info',
    'global.companyName' => 'global.companyName',
    'global.companyLogo' => 'global.companyLogo',
    'global.companyUrl' => 'global.companyUrl',
    'ticket.priority.placeHolders.info' => '	ticket.priority.placeHolders.info',
    'ticket.group.placeHolders.info' => 'ticket.group.placeHolders.info',
    'ticket.team.placeHolders.info' => 'ticket.team.placeHolders.info',
    'ticket.customerName.placeHolders.info' => '	ticket.customerName.placeHolders.info',
    'ticket.customerEmail.placeHolders.info' => '	ticket.customerEmail.placeHolders.info',
    'ticket.agentName.placeHolders.info' => 'ticket.agentName.placeHolders.info',
    'ticket.agentEmail.placeHolders.info' => 'ticket.agentEmail.placeHolders.info',
    'ticket.link.placeHolders.info' => '	ticket.link.placeHolders.info ',
    'ticket.id.placeHolders.info' => 'ticket.id.placeHolders.info',
    'ticket.subject.placeHolders.info' => '	ticket.subject.placeHolders.info',
    'ticket.status.placeHolders.info' => 'ticket.status.placeHolders.info',
    'comma "," separated' => 'comma separated (,)',
    'Low' => 'Low',
    'Medium' => 'Medium',
    'High' => 'High',
    'Urgent' => 'Urgent',
    'Reset Password' => 'Reset Password',
    'Enter your new password below to update your login credentials' => 'Enter your new password below to update your login credentials',
    'Save Password' => 'Save Password',
    'Rate Support' => 'Rate Support',
    'I am very Sad' => 'I am very disappointed',
    'I am Sad' => 'I am disappointed',
    'I am Neutral' => 'I am satisfied',
    'I am Happy' => 'I am happy',
    'I am Very Happy' => 'I am very happy',
    'Kudos' => 'Kudos',
    'kudos' => 'Kudos',
    'Very Sad' => 'Very disappointed',
    'Sad' => 'Disappointed',
    'Neutral' => 'Satisfied',
    'Happy' => 'Happy',
    'Very Happy' => 'Very Happy',
    'Star(s)' => 'Star(s)',
    'Warning ! Swiftmailer not working. An error has occurred while sending emails!' => 'Warning ! Swiftmailer not working. An error has occurred while sending emails!',
    'Invalid credentials.' => 'Invalid credentials',
    'Success ! Project cache cleared successfully.' => 'Success! Project cache cleared successfully.',
    'clear cache' => 'clear cache',
    'Last Updated' => 'Last Updated',
    'Error! Something went wrong.' => 'Error! Something went wrong.',
    'We were not able to find the page you are looking for.' => 'We were not able to find the page you are looking for.',
    'Page not found' => 'Page not found',
    'Forbidden' => 'Forbidden',
    'You don’t have the necessary permissions to access this Web page :(' => 'You don’t have the necessary permissions to access this Web page :(',
    'Internal server error' => 'Internal server error',
    'Our system has goofed up for a while, but good part is it won\'t last long' => 'Our system has goofed up for a while, but good part is it won\'t last long',
    'Unknown Error' => 'Unknown Error',
    'We are quite confused about how did you land here:/' => 'We are quite confused about how did you land here :/',
    'Few of the links which may help you to get back on the track -' => 'Few of the links which may help you to get back on the track -',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);

return $catalogue;
